/*
 * if_ppp.h - Point-to-Point Protocol definitions.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Portions Copyright (C) 1990 Brad K. Clements (streams support)
*/

/*
 * Standard PPP header.
 */
struct ppp_header {
	u_char	ph_address;	/* Address Field */
	u_char	ph_control;	/* Control Field */
	u_short	ph_protocol;	/* Protocol Field */
};

#define	PPP_ALLSTATIONS	0xff	/* All-Stations broadcast address */
#define	PPP_UI		0x03	/* Unnumbered Information */
#define	PPP_FLAG	0x7e	/* Flag Sequence */
#define	PPP_ESCAPE	0x7d	/* Asynchronous Control Escape */
#define	PPP_TRANS	0x20	/* Asynchronous transparency modifier */

/*
 * Protocol types.
 */
#define PPP_IP		0x21	/* Internet Protocol */
#define	PPP_XNS		0x25	/* Xerox NS */
#define	PPP_VJC_COMP	0x2d	/* VJ compressed TCP */
#define	PPP_VJC_UNCOMP	0x2f	/* VJ uncompressed TCP */

/*
 * Important FCS values.
 */
#define PPP_INITFCS	0xffff	/* Initial FCS value */
#define PPP_GOODFCS	0xf0b8	/* Good final FCS value */
#define PPP_FCS(fcs, c)	(((fcs) >> 8) ^ fcstab[((fcs) ^ (c)) & 0xff])

#define	PPP_MTU		1500	/* Default MTU (size of Info field) */
#define	PPP_HIWAT	1000	/* Don't start a new packet if HIWAT on queue */
#define	CLISTRESERVE	1000	/* Can't let clists get too low */

#define QUEUE_SIZE 40 
#define QUEUE_LOW 10
#define QUEUE_HIGH 20
struct nb_queue
{
    int		head;
    int		tail;
    netbuf_t	queue[QUEUE_SIZE];
}
;

struct ppp_softc {
	struct ifnet* sc_if;	/* network-visible interface */
	short	sc_flags;	/* see below */
	struct	tty *sc_ttyp;	/* pointer to tty structure */
	u_short	sc_fcs;		/* FCS so far */
	u_long	sc_asyncmap;	/* async control character map */
	struct nb_queue inq;	/* reserve netbufs */
	netbuf_t tin_nb;	/* Current TTY input netbuf */
	struct nb_queue sndq;
	netbuf_t in_nb;		/* Input available to user ppp */
#ifdef VJC
	struct slcompress comp;
#endif
};

/* flags */
#define	SC_ESCAPED	0x0001	/* saw a PPP_ESCAPE */
#define	SC_FLUSH	0x0002	/* flush input until next PPP_FLAG */

#define t_sc T_LINEP

#ifdef	STREAMS
/* defines for streams modules */
#define	IF_INPUT_ERROR	0xe1
#define	IF_OUTPUT_ERROR	0xe2

#define	ALLOCBSIZE	64		/* how big of a buffer block to allocate for each chunk of the input chain */
#endif
