/* command.h - definitions for expect commands

Written by: Don Libes, NIST, 2/6/90

Design and implementation of this program was paid for by U.S. tax
dollars.  Therefore it is public domain.  However, the author and NIST
would appreciate credit if this program or parts of it are used.
*/

#if TCL_MAJOR_VERSION == 6
#	define EVALJUNK		,0,(char **)0
#else
#	define EVALJUNK
#endif

struct f *exp_update_master();

#define get_var(x)	exp_get_var(interp,x)
char *exp_get_var();

extern int exp_default_match_max;
extern int exp_default_parity;
int exp_one_arg_braced();
int exp_eval_with_one_arg();
void exp_timestamp();
void exp_lowmemcpy();

#define USER_SPAWN_ID		0
#define USER_SPAWN_ID_LIT	"0"
#define exp_is_stdinfd(x)	((x) == 0)

#define EXP_NOPID	0	/* Used when there is no associated pid to */
				/* wait for.  For example: */
				/* 1) When fd opened by someone else, e.g., */
				/* Tcl's open */
				/* 2) When entry not in use */
				/* 3) To tell user pid of "spawn -open" */
				/* 4) stdin, out, error */

/* each process is associated with a 'struct f'.  An array of these ('fs') */
/* keeps track of all processes.  They are indexed by the true fd to the */
/* master side of the pty */
struct f {
	int pid;	/* pid or EXP_NOPID if no pid */
	char *buffer;	/* input buffer */
	char *lower;	/* input buffer in lowercase */
	int size;	/* current size of data */
	int msize;	/* size of buffer */
	int umsize;	/* user view of size of buffer */
	int valid;	/* if any of the other fields should be believed */
	int user_closed;/* if user has issued "close" command or close has */
			/* occurred implicitly */
	int sys_closed;	/* if close() has been called */
	int user_waited;/* if user has issued "wait" command */
	int sys_waited;	/* if wait() (or variant) has been called */
	int wait;	/* raw status from wait() */
	int parity;	/* strip parity if false */
	int printed;	/* # of characters written to stdout (if logging on) */
			/* but not actually returned via a match yet */
	int echoed;	/* additional # of chars (beyond "printed" above) */
			/* echoed back but not actually returned via a match */
			/* yet.  This supports interact -echo */
	int key;	/* unique id that identifies what command instance */
			/* last touched this buffer */
	int force_read;	/* force read to occur (even if buffer already has */
			/* data).  This supports interact CAN_MATCH */
	int armed;	/* If Tk_CreateFileHandler is active */
	char *tcl_handle;/* If opened by someone else, i.e. Tcl's open */
	int tcl_output;	/* output fd if opened by someone else */
			/* input fd is the index of this struct (see above) */
};
extern struct f *fs;

struct f *exp_fd2f();
int exp_adjust();
int exp_close();

#define exp_deleteProc (void (*)())0

extern int expect_key;

extern int exp_disconnected;

extern int exp_close_count;	/* # of times descriptors have been closed */

void exp_create_commands();
void exp_init_pty();
void exp_init_expect();
void exp_init_spawn();
void exp_init_spawn_ids();
void exp_init_spawn_id_vars();
void exp_init_trap();
void exp_init_unit_random();
void exp_init_sig();
void exp_init_debugger();

void exp_generic_sighandler();

#define exp_new(x)	(x *)malloc(sizeof(x))

struct exp_fd_list {
	int fd;
	struct exp_fd_list *next;
};

/* describes a -i flag */
struct exp_i {
	int direct;	/* if direct, then the spawn ids have been given */
			/* literally, else indirectly through a variable */
	int dynamic;	/* if dynamic, char ptrs here had to be malloc'd */
			/* because Tcl command line went away - i.e., in */
			/* expect_before/after */
	char *variable;
	char *value;	/* if type == direct, this is just the value of the */
		/* -i flag.  If indirect, it is the cached value of variable */
		/* use this to tell if it has changed or not, and ergo */
		/* whether it's necessary to reparse */
	struct exp_fd_list *fd_list;
	struct exp_i *next;
};

struct exp_i *exp_new_i_complex();
struct exp_i * exp_new_i_simple();
struct exp_fd_list *exp_new_fd();
void exp_free_i();
void exp_free_fd();
int exp_i_update();
