/* This script demonstrates a simple transfer protocol which uses a transfer
   progress panel.  This is just like cat.

-> File list and file sizes are known.  Example: ZMODEM send.
*/
#import "TransferProgressProtocol.h"
#import <libc.h>
#define NOTIFYCHUNK 1024

static id remote;

/* When user clicks Abort button in the transfer progress panel,
   SIGTERM is sent to the TickleTop process group. */
void transfer_abort(int sig)
{
  [remote transferMessage:"Aborted!"];
  sleep(1);
  [remote transferEnd];
  exit(0);
}

int main(int argc, char **argv)
{
  struct stat statbuf;
  int i,j,c;
  FILE *fp;

  if(argc<=1) {
    fprintf(stderr,"Usage: %s file ...\n",argv[0]);
    exit(1);
  }
#ifdef __STRICT_BSD__
  signal(SIGTERM,(int*)(int)transfer_abort);
#else
  signal(SIGTERM,(void*)(int)transfer_abort);
#endif

  remote=getProgressListener();
  [remote transferBegin:"Ascii Send"];

  // Tell TipTop what files we will be transfered:
  for(i=1;i<argc;i++) {
    if(access(argv[i],R_OK)<0 || stat(argv[i],&statbuf)<0) {
      fprintf(stderr,"%s: File %s: %s\n",
	      argv[0],argv[i],strerror(cthread_errno()));
      continue;
    }
    [remote transferFile:argv[i] size:statbuf.st_size];
  }

  for(i=1;i<argc;i++) {
    if(access(argv[i],R_OK)<0 || stat(argv[i],&statbuf)<0
       || (fp=fopen(argv[i],"r"))==NULL) continue;

    [remote transferFileBegin:argv[i]];
    for(j=0;;j++) {
      c=fgetc(fp);
      if(c==EOF) break;
      fputc(c,stdout);

      if(j%NOTIFYCHUNK==0) [remote transferProgress:j];
    }
    fclose(fp);
  }

  [remote transferEnd];
  exit(0);
}
