/* $Id$
   Copyright 1994 TipTop Software
*/

#import <appkit/appkit.h>
#import "SessionProtocol.h"

@interface TTSessionPanel:Panel
{
  id <SessionProtocol> session;
  
  BOOL running;
  BOOL hideOnMiniaturize;
  BOOL hideWhenDeselected;
  BOOL followSessionWindow;
  BOOL wantsToBeKey;
  BOOL stopWhenTickleExits;
  NXPoint windowPositionOffset;
}


+ newForSession:(id <SessionProtocol>)s fromZone:(NXZone *)z;
- session;

- init;

- (BOOL)wantsToBeRemembered;

- run:sender;
- stop:sender;
- (BOOL)isRunning;

- setHideOnMiniaturize:(BOOL)f;
- (BOOL)hideOnMiniaturize;

- setHideWhenDeselected:(BOOL)f;
- (BOOL)hideWhenDeselected;

- setFollowSessionWindow:(BOOL)f;
- (BOOL)followSessionWindow;

- setWantsToBeKey:(BOOL)f;
- (BOOL)wantsToBeKey;

- setStopWhenTickleExits:(BOOL)f;
- (BOOL)stopWhenTickleExits;
@end
