/* errors.m
 * Routines to simplify the checking and reporting of mach/sound kit/sound
 * driver errors.
 *
 * !!!
 * This file needs to be reworked under 3.0!!  The snd_msgs.h file has
 * gone away.  The workaround is described in NeXTAnswer sound.855.
 * !!!
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 *
 * Written by: Robert Poor
 * Created: Sep/92
 */

#import "errors.h"
#import <appkit/Panel.h>
// #import "LanguageApp.h"
#import <mach_error.h>
#import <sound/sounderror.h>
// #import <nextdev/snd_msgs.h>		/* for SND_NO_ERROR */
#define SND_NO_ERROR	0		/* not defined in 3.0? */

static char *snddriver_error_list[] = {
  "sound success",
  "sound message sent to wrong port",
  "unknown sound message id",
  "bad parameter list in sound message",
  "can't allocate memory for recording",
  "sound service in use",
  "sound service requires ownership",
  "DSP channel not initialized",
  "can't find requested sound resource",
  "bad DSP mode for sending data commands",
  "external pager support not implemented",
  "sound data not properly aligned"
  };

char *snddriver_error_string(int error)
{
  return ((error >= SND_NO_ERROR)?
	  snddriver_error_list[error-SND_NO_ERROR]:
	  "unrecognized sound error message");
}

id checkMachError(id obj, int err, char *msg)
{
  if (err != KERN_SUCCESS) {
#if 0
    NXRunAlertPanel(NULL,
		    [NXApp translateString:msg fromTable:"alerts"],
		    [NXApp translateString:"OK" fromTable:"buttons"],
		    NULL,
		    NULL);
#else
    NXRunAlertPanel(NULL, msg, "OK", NULL, NULL);
#endif
    return nil;
  }
  return obj;
}

id checkSnddriverError(id obj, int err, char *msg)
{
  if (err != KERN_SUCCESS) {
#if 0
    NXRunAlertPanel(NULL,
		    [NXApp translateString:msg fromTable:"alerts"],
		    [NXApp translateString:"OK" fromTable:"buttons"],
		    NULL,
		    NULL);
#else
    NXRunAlertPanel(NULL, msg, "OK", NULL, NULL);
#endif
    return nil;
  }
  return obj;
}

id checkSNDError(id obj, int err, char *msg)
{
  if (err != SND_ERR_NONE) {
#if 0
    NXRunAlertPanel(NULL,
		    [NXApp translateString:msg fromTable:"alerts"],
		    [NXApp translateString:"OK" fromTable:"buttons"],
		    NULL,
		    NULL);
#else
    NXRunAlertPanel(NULL, msg, "OK", NULL, NULL);
#endif
    return nil;
  }
  return obj;
}
