/*****************************************************************************/
/*									     */
/*									     */
/*	X patience - cards.c						     */
/*									     */
/*	written by Heiko Eissfeldt and Michael Bischoff			     */
/*									     */
/*	24-Feb-1993: First release (0.1)				     */
/*									     */
/*									     */
/*****************************************************************************/
#include "xpat.h"
#include "xpatx11.h"

#ifndef NO_ROUND_CARDS
#include	<X11/Xmu/Drawing.h>
#endif



void redraw_buttons(int x, int y, int w, int h, Window win, int num, struct singlebutton *p)
{
    while (num--) {
	if (x >= p->x + p->w || x + w < p->x ||
	    y >= p->y + p->h || y + h < p->y) {	/* does not intersect */
	    ++p;
	    continue;
        }
#ifndef NO_ROUND_CARDS
	if (B_ROUND_W)	{
	    /* fill the background */
	    XmuFillRoundedRectangle(dpy, win, whitegc, p->x, p->y, 
		p->w-1, p->h-1, B_ROUND_W, B_ROUND_H);
	    /* draw the text */
            XDrawImageString(dpy, win, button.gc, p->x + button.bx, p->y +
  	       button.by + button.font->ascent, p->text, strlen(p->text));
	    /* draw border on button */
	    XmuDrawRoundedRectangle(dpy, win, blackgc, p->x, p->y, 
		p->w-1, p->h-1, B_ROUND_W, B_ROUND_H);
	} else	
#endif
	{
	    /* fill the background */
	    XFillRectangle(dpy, win, whitegc, p->x, p->y, p->w-1, p->h-1);
	    /* draw the text */
            XDrawImageString(dpy, win, button.gc, p->x + button.bx, p->y +
  	       button.by + button.font->ascent, p->text, strlen(p->text));
	    /* draw border on button */
	    XDrawRectangle(dpy, win, blackgc, p->x, p->y, p->w-1, p->h-1);
	}
	++p;

    }
}


/* all card drawings go through this routine: */

void draw_pileupdate(int pile, int delta)
{   struct pile *p = graphic.pile + pile;

    if (!graphic.enable)        /* this is off when replaying saved games */
        return;
    if (NOT_DISPLAYED(p))
	return;			/* nichts zeichnen */

    switch (game.piletype[pile]) {
    case FacedownDeck:
	if (!delta)
	    PaintCard(p->x, p->y, EMPTY(pile) ? OUTLINE : CARDBACK, 0);
	return;
    case FaceupDeck:
	/* if (delta)
	    return;	*/ /* only draw once */
    case Stack:
    case Tmp:
	/* look, that's C: (!) */
	PaintCard(p->x, p->y,
            EMPTY(pile) ? (game.piletype[pile] != Stack ? OUTLINE :
               SUITSYMBOL + SUIT(pile)) : game.cards[INDEX_OF_LAST_CARD(pile)],
            0);
	if (game.srcind >= 0 && getpile(game.srcind) == pile)
	    show_mark(True);
	return;
    case Slot:
	/* this is the most work, and we must optimize it */
	/* try to draw as least as possible */	
	{   int height, deltachanged = False;
	    int start;
	    height = p->totalheight;
	    if (delta) {		/* cards on pile have changed */
		deltachanged = pile_resize(pile);
		if (height < p->totalheight)
		    height = p->totalheight;	/* max */
		if (deltachanged)
		    XClearArea(dpy, table, p->x, p->y, CARD_WIDTH, height, False);
	    }
	    
	    if (EMPTY(pile)) {
		if (height < p->maxheight)
		    height = p->maxheight;
		XClearArea(dpy, table, p->x, p->y, CARD_WIDTH, height, False);
		return;
	    }
	    if (!delta || deltachanged) {	/* must draw all */
		start = game.ind[pile];		/* start with first card on pile */
	    } else {				/* quick update */
		if (delta > 0) {		/* just draw the new cards */
		    start = game.ind[pile+1] - delta;
		} else {
		    int yy;
#if 0
		    if (EMPTY(pile)) {
			XClearArea(dpy, table, p->x, p->y, CARD_WIDTH, height, False);
			return;
		    }
#endif
		    /* just draw the last card which is visible, clear the space below */
		    start = INDEX_OF_LAST_CARD(pile);
		    yy = graphic.cardy[start] + CARD_HEIGHT - ROUND_H;
		    assert(height > yy);
		    XClearArea(dpy, table, p->x, p->y + yy, CARD_WIDTH, height - yy, False);
		}
	    }
	    /* area is clear, draw pile from "start" */
	    {   int j;
		for (j = start; j != INDEX_OF_LAST_CARD(pile); ++j) {	/* non-top card */
		    /* printf("cardy = %d / %d\n", graphic.cardy[j], graphic.cardy[j+1]); */
		    PaintCard(p->x, p->y + graphic.cardy[j], (game.visible[j] ? game.cards[j] : CARDBACK),
			      graphic.cardy[j+1]-graphic.cardy[j]);
		}
		/* paint last card */
		/* last card is always visible */
		PaintCard(p->x, p->y + graphic.cardy[j], game.cards[j], 0);
		if (game.srcind >= 0 && getpile(game.srcind) == pile)
		    show_mark(True);
	    }
	}
	return;
    } /* end switch */
}


