/*  load.l

    Copyright (C) 1994	Lambert Klasen & Detlef Steuer
			klasen@asterix.uni-muenster.de
			steuer@amadeus.statistik.uni-dortmund.de

    This file is free source code; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
    COPYING for more details.
 */



%{
#include <stdlib.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Label.h>
#include "xgammon.h"
#include "gammon.h"

char kind;

static int color, count = 0, p;
static int found_black, found_white;
static char *format_str;
static have_tournament = 0;

extern Widget text_display, tournament_display, t_label, p_label;
extern int move_count;
extern int break_loop, end_of_game;
extern char add_text[];

extern void draw_empty_board();
extern void redraw_all_stones();
extern void DrawDice();
extern void draw_doubler();
extern void XGammonGameLoop();
extern void AppendDialogText();
%}

%s DICE
%s TURN
%s DBLR
%s L_BAR
%s PIN
%s TOURNAMENT
%s WHITEPOINTS
%s BLACKPOINTS
%s GAME

%%
turn			{ BEGIN TURN; }
<TURN>black	{
	        turn  = BLACK;
	        other = WHITE;
	        direction = 1;
	        start_pin = 0;
	        end_pin = 25;
		BEGIN 0; 
		}
<TURN>white	{ 
		turn = WHITE; 
	        other = BLACK;
	        direction = -1;
	        start_pin = 25;
	        end_pin = 0;
		BEGIN 0; 
		}

dice			{ BEGIN DICE; }
<DICE>[1-6]	{
		  roll[count] = *(yytext) - '0';
		  count++; 
		  if (count == 2) {
			roll[0] *= direction;
			roll[1] *= direction;

			if (roll[0] == roll[1]) { 
			        roll[3] = roll[0]; 
			        roll[2] = roll[1]; 
			        to_move = 4;
			        pash = 1;
			        }
			else {
			        roll[2] = roll[3] = 0;
			        pash = 0;
			        to_move = 2;
			        }
			count = 0; 
			BEGIN 0;
			}
		}

doubler		{ BEGIN DBLR; }
<DBLR>1|2|4|8|16|32|64 	{
				doubler_value = atoi(yytext);
				}
<DBLR>(none|black|white)	{ 
				if      (*yytext == 'b') last_doubler = BLACK;
				else if (*yytext == 'w') last_doubler = WHITE;
				else last_doubler = 0;
				BEGIN 0; 
				}

bar		{ BEGIN L_BAR; }
<L_BAR>black	{ 
		color = BLACK; 
		count++;
		}
<L_BAR>white	{
		color = WHITE; 
		count++;
		}
<L_BAR>[0-9]+ 	{ 
		if (color == BLACK) {
			if ((Pin[0].count = atoi(yytext))) Pin[0].color = color;
			found_black += Pin[0].count;
			}
		else {
			if ((Pin[25].count = atoi(yytext))) Pin[25].color = color;
			found_white += Pin[25].count;
			}

		if (count == 2) {
			count = 0; 
			BEGIN 0;
			}
		}

pin			{ BEGIN PIN; count = 0; }
<PIN>[0-9]+[ \t]*white	{ 
			Pin[p].color = WHITE; 
			Pin[p].count = atoi(yytext); 
			found_white += Pin[p].count;
			BEGIN 0;
			}
<PIN>[0-9]+[ \t]*black	{
			Pin[p].color = BLACK; 
			Pin[p].count = atoi(yytext); 
			found_black += Pin[p].count;
			BEGIN 0;
			}
<PIN>[0-9]+		{ 
			p = atoi(yytext); 
			}

tournament		{ if (kind == 'g') {
				BEGIN TOURNAMENT; 
				have_tournament = 1;
				}
			}
<TOURNAMENT>money	{ format_str = "money-game:";
			  tournament.winning_point = 0; 
			  gammon_resource.moneygame = 1;
			}
<TOURNAMENT>best	{ format_str = "tournament: best of %d";
			  gammon_resource.moneygame = 0;
			}
<TOURNAMENT>win		{ format_str = "tournament: win at %d points";
			  gammon_resource.moneygame = 0;
			}
<TOURNAMENT>[0-9]+	{ tournament.winning_point = atoi(yytext); }
<TOURNAMENT>white	{ BEGIN WHITEPOINTS; }
<TOURNAMENT>black	{ BEGIN BLACKPOINTS; }
<TOURNAMENT>game	{ BEGIN GAME; }
<WHITEPOINTS>[0-9]+	{ tournament.points[WHITE] = atoi(yytext); BEGIN TOURNAMENT; }
<BLACKPOINTS>[0-9]+	{ tournament.points[BLACK] = atoi(yytext); BEGIN TOURNAMENT; }
<GAME>[0-9]+		{ tournament.game_number = atoi(yytext); }
<TOURNAMENT>turn	{ BEGIN turn; }

.       ;
\n       ;
%%

void load(w, e, vector, count)
    Widget      w;
    XEvent      *e;
    String      *vector;
    Cardinal    *count;
{
	FILE *f;
	int i;
	char * filename = "xgammon.save";
	static int wraped = 0;

	if      (*vector[0] == 'p') kind = 'p';
	else if (*vector[0] == 'g') kind = 'g';
	else if (*vector[0] == 'm') {
		kind = 'g';
		filename = vector[1];
	}

	f = fopen(filename,"r");

	if (!f) {
        	AppendDialogText(text_display, "Couldn't open save file for reading, sorry!\n");
        	return;
        }

	for (i=0; i<29; i++) { Pin[i].color = 0; Pin[i].count = 0; }
	found_black = found_white = 0;

	if (!wraped) { yyin = f; wraped = 1; }
	else { yyin = f; YY_NEW_FILE; }

	count = 0;
	have_tournament = 0;
	BEGIN 0;

	yylex();

	fclose (f);

	if (found_white<15) Pin[25+WHITE].count = 15 - found_white;
	if (found_black<15) Pin[25+BLACK].count = 15 - found_black;

	if (turn == BLACK) {
		Player[0].beginner_of_game = 1;
		Player[1].beginner_of_game = 0;
	}
	else {
		Player[0].beginner_of_game = 0;
		Player[1].beginner_of_game = 1;
	}

	if (!gammon_resource.rollout) {
		draw_empty_board();
		redraw_all_stones();
		DrawDice(turn);
		draw_doubler(doubler_value, last_doubler);

		tournament.points[BLACK] = tournament.points[WHITE] = 0;

		AppendDialogText (tournament_display, "\ntournament restart\nloading position\n");

		if (have_tournament && !gammon_resource.moneygame) {
			if (tournament.winning_point)
				sprintf(add_text, format_str, tournament.winning_point);
			else    sprintf(add_text, format_str);
			AppendDialogText( tournament_display, add_text);
			sprintf(add_text, "white points: %d, black points: %d", tournament.points[WHITE], tournament.points[BLACK]);
			AppendDialogText( tournament_display, add_text);
		}
		else {
			AppendDialogText( tournament_display, "money-game:\n");
			tournament.winning_point = 0;
			tournament.points[WHITE] = tournament.points[BLACK] = 0;
			sprintf(add_text, "white points: %d, black points: %d", tournament.points[WHITE], tournament.points[BLACK]);
			AppendDialogText( tournament_display, add_text);
		}

		AppendDialogText (text_display, "\ngame aborted\n\nnew game from loaded position:\n");

		move_count = 1;
		sprintf (add_text, "move  1 (dice %d, %d): ", roll[0], roll[1]);
		AppendDialogText (text_display, add_text);

		break_loop = LOADED_POSITION;
		end_of_game = 1;
		/*XGammonGameLoop();*/
	}
}
