/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: xv_tasten.c
**
** Kommentar:
**  Wertet Events von der Tastatur aus und setzt definierte Signale
*/


#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>

#include "signale.h"
#include "ereignisse.h"
#include "einaus.h"
#include "grafik.h"
#include "xv_einaus.h"

static char sccsid[] = "@(#)xv_tasten.c	1.12 5/17/94";


#define GEDRUECKT 1       /* Bit 0 wird gesetzt, wenn Taste gedrueckt;
                             und geloescht, wenn diese losgelassen */
#define NICHT_ABGEFRAGT 2 /* Bit 1 bleibt gesetzt, bis ein Tastendruck
                             registriert wurde */

/* die Cursor-Tasten haben eine Repeat-Funktion, alle anderen nicht */
#define HAT_REPEAT(signalnr) \
	((signalnr) == VORSIGNAL || (signalnr) == ZURUECKSIGNAL || \
	(signalnr) == LINKSSIGNAL || (signalnr) == RECHTSSIGNAL)

static char aktiv[SIGNALANZ];  /* aktueller Tastenzustand (GEDRUECKT /
                                  NICHT_ABGEFRAGT) */


/*
** event_routine
**  verarbeitet die Tastatur-Events und ordnet sie den internen Signalen zu
**
** Parameter:
**  window: Fenster fuer den der Event bestimmt ist
**  event: Beschreibung des Events
**
** Seiteneffekte:
**  aktiv wird veraendert
*/
static void event_routine(window, event)
Xv_Window window;
Event *event;
{
	int signalnr;  /* Index auf Tabelle mit Signalen */
	short action;  /* Typ bzw. ASCII-Code des Events */

	switch (action = event_action(event))
	{
		case 3: /* Control-C */
			if (event_is_down(event))
				disconnect_abfrage();
			return;
		case 17: /* Control-Q */
			signalnr = WEITERSIGNAL;
			break;
		case 19: /* Control-S */
			signalnr = STOPSIGNAL;
			break;
		case ' ': /* Leertaste */
			signalnr = SCHUSSSIGNAL;
			break;
		case ACTION_GO_COLUMN_BACKWARD: /* Cursor hoch */
			signalnr = VORSIGNAL;
			break;
		case ACTION_GO_COLUMN_FORWARD: /* Cursor runter */
			signalnr = ZURUECKSIGNAL;
			break;
		case ACTION_GO_CHAR_BACKWARD: /* Cursor links */
			signalnr = LINKSSIGNAL;
			break;
		case ACTION_GO_CHAR_FORWARD: /* Cursor rechts */
			signalnr = RECHTSSIGNAL;
			break;
		case '0': /* Tasten 0 bis 9 */
			signalnr = AKTIONSSIGNALE + 9;
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			signalnr = AKTIONSSIGNALE + action - '1';
			break;
		case KBD_DONE: /* Fenster verliert FOCUS (erhaelt keine
			   Tastatur-Eingaben mehr) */
			/* dann werden alle Tasten wie losgelassen behandelt */
			for (signalnr = 0; signalnr < SIGNALANZ; signalnr++)
				aktiv[signalnr] &= ~GEDRUECKT;
			return;
		default:
			return;
	}

	/* Taste wurde losgelassen */
	if (event_is_up(event))
	{
		aktiv[signalnr] &= ~GEDRUECKT;
	}
	/* Taste ist niedergedrueckt (neu oder durch repeat) */
	else
	{
		/* Falls Taste nicht zuvor schon gedrueckt war, als
		   gedrueckt und nicht abgefragt markieren */
		if (!(aktiv[signalnr] & GEDRUECKT))
			aktiv[signalnr] = GEDRUECKT | NICHT_ABGEFRAGT;
	}
}


/*
** frame_init
**  sucht in einem Fenster nach Unterfenstern vom Typ CANVAS und
**  initialisiert darin die Event-Abfrage
**
** Parameter:
**  frame: Fenster, in dem gesucht werden soll
*/
static void frame_init(frame)
Frame frame;
{
	int i;
	Window subwindow;

	for (i = 1; (subwindow = xv_get(frame,
		FRAME_NTH_SUBWINDOW, i)) != 0; i++)
		if ((Xv_pkg *)xv_get(subwindow, XV_TYPE) == CANVAS)
		{
			/* KBD_DONE: Fenster verliert FOCUS
			   WIN_ASCII_EVENT: Tasten werden gedrueckt
			   WIN_UP_EVENT: Taste losgelassen (wird evtl.
			   nicht unterstuetzt) */
			xv_set(canvas_paint_window(subwindow),
				WIN_CONSUME_EVENTS,
					KBD_DONE, WIN_ASCII_EVENTS, WIN_UP_EVENTS, 0,
				WIN_EVENT_PROC, event_routine,
				0);
		}
}


/* bis hier lokaler Teil                       */
/***********************************************/
/* ab hier globaler Teil                       */


/*
** eingabe_abfragen
**  setzt in einem Feld aller Signale diejenigen, die seit der letzten
**  Abfrage aufgetreten sind. Die Tasten werden als abgefragt markiert
**
** Paramter:
**  signale: Feld mit allen Signalen
**           (0 = nicht aufgetreten; 1 = aufgetreten)
**
** Seiteneffekte:
**  aktiv und signale wird veraendert
*/
void eingabe_abfragen(signale)
char signale[SIGNALANZ];
{
	int signalnr;  /* Index auf Tabelle mit Signalen */

	for (signalnr = 0; signalnr < SIGNALANZ; signalnr++)
	{
		/* Falls REPEAT-Funktion vorgesehen (Cursor-Tasten),
		   Signal setzen, wenn GEDRUECKT oder NICHT_ABGEFRAGT,
		   sonst nur wenn NICHT_ABGEFRAGT */
		if (HAT_REPEAT(signalnr))
			signale[signalnr] = aktiv[signalnr] != 0;
		else
			signale[signalnr] =
				(aktiv[signalnr] & NICHT_ABGEFRAGT) != 0;

		/* alle Tasten als ABGEFRAGT markieren */
		aktiv[signalnr] &= ~NICHT_ABGEFRAGT;
	}
}


/*
** xv_eingabe_init
**  sucht nach Unterfenstern vom Typ CANVAS und initialisiert darin
**  die Event-Abfrage
**
** Parameter:
**  hauptframe: Fenster, von dem alle anderen Fenster abstammen
**  panel: Panel, in dem Buttons ergaenzt werden duerfen
*/
void xv_eingabe_init(hauptframe, panel)
Frame hauptframe;
Panel panel;
{
	int i;
	Frame subframe;

	/* im Hauptfenster suchen */
	frame_init(hauptframe);

	/* in allen weiteren Fenstern suchen */
	for (i = 1; (subframe = xv_get(hauptframe,
		FRAME_NTH_SUBFRAME, i)) != 0; i++)
		frame_init(subframe);
}


/*
** xv_eingabe_ende
**  Dummy-Routine fuer das Schliessen von Eingabekanaelen etc.
*/
void xv_eingabe_ende()
{
}
