/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _RISK
#define _RISK

#include "types.h"

/* Fields of the RiskGame object */
#define PLR_ATTACKMODE       0   /* Remembers the attack mode of the player */
#define PLR_MSGDSTMODE      22   /* Remembers the last message destination */
#define PLR_DICEMODE        23   /* Remembers the last die mode */

#define PLR_STATE            1   /* Either TRUE = Alive, FALSE = Dead */
#define PLR_CLIENT           2   /* The client of the player */
#define PLR_NUMCOUNTRIES     3   /* Number of territories the player owns */
#define PLR_NUMARMIES        4   /* Number of armies the player holds */
#define PLR_NUMCARDS         5   /* Number of cards the player holds */
#define PLR_NAME             6   /* Name of the player */
#define PLR_COLORSTRING      7   /* Name of the color of the player */
#define PLR_COLORINDEX       8   /* Index of the player's color in the cmap */
#define PLR_CARD             9   /* A card of the player */

#define CNT_NAME            10   
#define CNT_CONTINENT       11
#define CNT_NUMARMIES       12
#define CNT_OWNER           13
#define CNT_ADJCOUNTRY      14
#define CNT_TEXTX           15
#define CNT_TEXTY           16

#define CON_NAME            17
#define CON_VALUE           18
#define CON_NUMCOUNTRIES    19

#define GEN_NUMPLAYERS      20
#define GEN_NUMLIVEPLAYERS  21

/* Port at which the clients can find the server */
#define RISK_PORT 5324

/* Limits */
#define MAX_CLIENTS     10
#define MAX_CARDS       10
#define MAX_PLAYERS      8
#define MAX_COLORS     256

/* Numbers */
#define NUM_CONTINENTS     6
#define NUM_COUNTRIES     42
#define NUM_OTHERCOLORS    3
#define NUM_CARDS         44

/* Card types */
#define CARD_CANON    0
#define CARD_FOOTMAN  1
#define CARD_HORSEMAN 2
#define CARD_JOKER    3 

/* Continents */
#define CNT_NORTHAMERICA  0 
#define CNT_SOUTHAMERICA  1
#define CNT_AFRICA        2
#define CNT_AUSTRALIA     3
#define CNT_ASIA          4
#define CNT_EUROPE        5

/* Macros */
#ifdef MAX
#undef MAX
#endif
#define MAX(a, b) ((a)>(b)?(a):(b))

#ifdef MIN
#undef MIN
#endif
#define MIN(a, b) ((a)>(b)?(b):(a))

/* States in risk state machine */
#define STATE_REGISTER  0
#define STATE_PLACE     1
#define STATE_FORTIFY   2
#define STATE_ATTACK    3
#define STATE_MOVE      4

/* Defines for widgets */
#define ATTACK_ONE     0
#define ATTACK_TWO     1
#define ATTACK_THREE   2
#define ATTACK_AUTO    3

#define ACTION_PLACE   0
#define ACTION_ATTACK  1
#define ACTION_DOORDIE 2
#define ACTION_MOVE    3

/* The main modes are SERVER and CLIENT.  If the object is created as
 * a SERVER, it broadcasts information to the other clients when it receives
 * updates from another CLIENT.  If the object is created as a CLIENT, it
 * just updates its own fields when it receives an update.
 */

#define MODE_CLIENT            1
#define MODE_SERVER            2

/* A PERSISTANT object will maintain a copy of itself on secondary storage.  
 * Every time the object updates a field, it also updates the field on disk.
 */

#define MODE_PERSISTANT        4 


/* These functions support all of the functionality of the RiskGame structure,
 * in order for it to work as a fully distributed object.  The functions
 * are split into two catagories, those that receive input from a remote 
 * source (through a message), those that receive input from the local
 * client, which is sent back to the server to broadcast to all the other
 * clients, and those that return fields of the object to the local client.
 * This file serves the functionality of a C++ object -- I would use GCC but
 * its C++ side is not stable enough.
 */

void     RISK_Initialize(Int iMode, Int iWriteSock, Int iReadSock);
void     RISK_SelectiveReplicate(Int iWriteSocket, Int iField, 
				 Int iMin1, Int iMax1, 
				 Int iMin2, Int iMax2);
void     RISK_ResetObj(void);
void     RISK_ResetGame(void);
void     RISK_ProcessMessage(Int iMessType,void *pMessage, Int iClientSrc);
Int      RISK_AllocPlayer(void (*pfMsgHandler)(Int, void *));
void     RISK_FreePlayer(Int i);

void     RISK_SetBroadcastCallback(void (*func)(Int, void *));
void     RISK_SetSendMsgCallback(void (*func)(Int, Int, void *));
void     RISK_SetSendSyncMsgCallback(void (*func)(Int, Int, void *, Int, Int, 
					    void (*foo)(Int, void *)));
void     RISK_SetMessageCallback(void (*func)(Int, void *));
void     RISK_SetFinishBroadcastCallback(void (*func)(Int, Int, void *));

void     RISK_SetAttackModeOfPlayer(Int iPlayer, Int iMode);
void     RISK_SetDiceModeOfPlayer(Int iPlayer, Int iMode);
void     RISK_SetMsgDstModeOfPlayer(Int iPlayer, Int iMode);
void     RISK_SetStateOfPlayer(Int iPlayer, Boolean fState);
void     RISK_SetClientOfPlayer(Int iPlayer, Int iClient);
void     RISK_SetNumCountriesOfPlayer(Int iCountry, Int iNumCountries);
void     RISK_SetNumArmiesOfPlayer(Int iCountry, Int iNumArmies);
void     RISK_SetNumCardsOfPlayer(Int iPlayer, Int iNumCards);
void     RISK_SetNameOfPlayer(Int iPlayer, String strName);
void     RISK_SetColorStringOfPlayer(Int iPlayer, String strColor);
void     RISK_SetColorIndexOfPlayer(Int iPlayer, Int iColor);
void     RISK_SetCardOfPlayer(Int iPlayer, Int iCard, Int iValue);
void     RISK_SetNameOfCountry(Int iCountry, String strName);
void     RISK_SetContinentOfCountry(Int iCountry, Int iContinent);
void     RISK_SetOwnerOfCountry(Int iCountry, Int iOwner);
void     RISK_SetNumArmiesOfCountry(Int iCountry, Int iNumArmies);
void     RISK_SetAdjCountryOfCountry(Int iCountry, Int iIndex, Int OtherC);
void     RISK_SetNumLivePlayers(Int iNumPlayers);
void     RISK_SetNumPlayers(Int iNumPlayers);

Int      RISK_GetDiceModeOfPlayer(Int iPlayer);
Int      RISK_GetMsgDstModeOfPlayer(Int iPlayer);
Int      RISK_GetAttackModeOfPlayer(Int iPlayer);
Boolean  RISK_GetStateOfPlayer(Int iPlayer);
Int      RISK_GetClientOfPlayer(Int iPlayer);
Int      RISK_GetNumCountriesOfPlayer(Int iCountry);
Int      RISK_GetNumArmiesOfPlayer(Int iCountry);
Int      RISK_GetNumCardsOfPlayer(Int iPlayer);
String   RISK_GetNameOfPlayer(Int iPlayer);
String   RISK_GetColorStringOfPlayer(Int iPlayer);
Int      RISK_GetColorIndexOfPlayer(Int iPlayer);
Int      RISK_GetCardOfPlayer(Int iPlayer, Int iCard);
String   RISK_GetNameOfCountry(Int iCountry);
Int      RISK_GetContinentOfCountry(Int iCountry);
Int      RISK_GetNumArmiesOfCountry(Int iCountry);
Int      RISK_GetOwnerOfCountry(Int iCountry);
Int      RISK_GetAdjCountryOfCountry(Int iCountry, Int iIndex);
Int      RISK_GetTextXOfCountry(Int iCountry);
Int      RISK_GetTextYOfCountry(Int iCountry);
Int      RISK_GetValueOfContinent(Int iContinent);
String   RISK_GetNameOfContinent(Int iContinent);
Int      RISK_GetNumCountriesOfContinent(Int iContinent);
Int      RISK_GetNumLivePlayers(void);
Int      RISK_GetNumPlayers(void);

#endif


