/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, Elan Feingold (feingold@zko.dec.com)           *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _GUI
#define _GUI

#include <X11/X.h>
#include <X11/Intrinsic.h>

#include "riskgame.h"
#include "colormap.h"

extern Widget wToplevel, wForm;
extern Widget wMap, wControls;
extern Widget wAttackLabel, wAttackList;
extern Widget wActionLabel, wActionList;
extern Widget wMsgDestLabel, wMsgDestList, wMsgDestViewport;
extern Widget wSendMsgText;
extern Widget wMsgText;
extern Widget wPlayField;
extern Widget wCommentLabel, wQuitButton, wRepeatButton, wCancelAttackButton;
extern Widget wHelpButton, wShowCardsButton;
extern Widget wEndTurnButton, wDiceBox;
extern Widget wArmiesLabel, wArmiesText;
extern Widget wCurrentPlayer, wErrorLabel;
extern Widget wRegisterShell, wRegisterForm;
extern Widget wNameLabel, wNameText;
extern Widget wColorLabel, wColorText;
extern Widget wRegisterButton, wStartGameButton;
extern Widget wCardShell, wCardForm, wCardTableBox;
extern Widget wCardViewport, wCardToggle[MAX_CARDS];
extern Widget wExchangeButton, wCancelCardsButton;
extern Widget wArmiesShell, wArmiesForm, wArmiesLabel, wArmiesText;
extern Widget wFinishArmiesButton, wCancelArmiesButton;
extern Widget wHelpShell, wHelpForm, wHelpTopicViewport, wHelpTopicList;
extern Widget wHelpTopicLabel, wHelpText, wHelpOkButton;
extern Widget wHelpLabel;
extern Widget wDialogShell, wDialogLabel, wDialogButton[3], wDialogForm;

extern XImage         *pMapImage;
extern Pixmap          pixMapImage;
extern Display        *hDisplay;
extern Window          hWindow;
extern int             iScreen, iNumColors;
extern GC              hGC;
extern XFontStruct    *pFont;
extern Colormap        cmapColormap;
extern Color           pColors[MAX_COLORS];

void GUI_Setup(int argc, char **argv);
void GUI_Start(void);
void GUI_AddCallbacks(int iReadSock);
void GUI_LoadMap(String strMapFile);

/* We need a structure that will map from a color to the country.  We
 * don't make it a necessity to allocate colors contiguously, so we
 * need this function.
 */

extern Int piColorToCountry[MAX_COLORS];

#endif
