/* sndcvt.c	-  Charles (nsa@link.xs4all.nl)
**
** convert 16bit sound of DOOM to 8bit ..
**
** (10sep94)
*/

#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/soundcard.h>

#define ERRMSG		  strerror(errno)
#define DSP_IN		  "/tmp/dsp"
#define DSP_OUT 	  "/dev/dsp"


void main(int argc, char **argv)
{
  unsigned short s[1024];
  unsigned char  b[1024];
  int		 ifd, ofd;
  int		 v, i, ret;

     ifd = open(DSP_IN, O_RDONLY);
     if(ifd < 0)
      {
	fprintf(stderr, "Can't open %s (rd): %s\n", DSP_IN, ERRMSG);
	exit(1);
      }
     ofd = open(DSP_OUT, O_WRONLY);
     if(ofd < 0)
      {
	fprintf(stderr, "Can't open %s (wr): %s\n", DSP_OUT, ERRMSG);
	exit(1);
      }

     v = 131083;
     ret = ioctl(ofd, SNDCTL_DSP_SETFRAGMENT, &v);
     if(ret) perror("SNDCTL_DSP_SETFRAGMENT");

     ret = ioctl(ofd, SNDCTL_DSP_RESET, 0);
     if(ret) perror("SNDCTL_DSP_RESET");

     v = 11025;
     ret = ioctl(ofd, SOUND_PCM_WRITE_RATE, &v);
     if(ret) perror("SOUND_PCM_WRITE_RATE");

     v = 1;
     ret = ioctl(ofd, SNDCTL_DSP_STEREO, &v);
     if(ret) perror("SNDCTL_DSP_STEREO");

     while(read(ifd, &s, 2048) == 2048)
      {
	for(i=0;i<1024;i++)
	 {
	   s[i] ^= 0x8000;
	   b[i]  = (s[i]>>8);
	 }
	write(ofd, &b, 1024);
      }
}

