#ifndef SCREEN_H
#define SCREEN_H

/* Memberwise initialisation and copying should be fine */

typedef unsigned char pixel;

class
Screen
{
private:
	static pixel *gmem;
	static scrwidth, scrheight;
	void copy (const Screen& s); 
public:
	Screen();
	Screen(const Screen& s);
	Screen& operator=(const Screen& s);
	int getScreenWidth(void) const { return scrwidth; };
	int getScreenHeight(void) const { return scrheight; };
	pixel* getGraphMem( void) const { return gmem; }

	void setScreenWidth(int w){ scrwidth=w;}
	void setScreenHeight(int h){ scrheight=h;}

	void setGraphMem( void *gptr) { gmem=(pixel *)gptr; }
};

#endif
