#include "screendefs.h"

.text
.align 4
.globl _screencopy
_screencopy:
	pushl %ebp		!Standard entry
	movl %esp,%ebp	

	pushl %ecx		!Save regs used
	pushl %esi
	pushl %edi

	movl $SCREENLENGTHL,%ecx	!A screen is 16000 dwords long
	movl 8(%ebp),%esi
	movl 12(%ebp),%edi
	rep
	movsl

	popl %edi		!Restore regs used
	popl %esi
	popl %ecx

	movl %ebp,%esp		!Standard exit
	popl %ebp
	ret

.align 4
.globl _showwindow
_showwindow:
	pushl %ebp		!Standard entry
	movl %esp,%ebp	
	
	pushl %esi
	pushl %edi	

	pushl %eax
	pushl %ebx
	pushl %ecx
	pushl %edx

	movl 8(%ebp),%esi	!Source
	movl 12(%ebp),%edi	!Destination
	movl 16(%ebp),%eax	!Image width
	movl $SCREENHEIGHT,%ebx	!Line counter
	subl $SCREENWIDTH,%eax	!Calulate adjustment

copyline:
	movl $20,%ecx	!A line is 80 dwords long

linestart:
	movsl
	movsl
	movsl
	movsl
	loop linestart

	movl %esi,%edx		!Do adjustment
	addl %eax,%edx
	movl %edx,%esi

	decl %ebx
	jne copyline

	popl %edx
	popl %ecx
	popl %ebx
	popl %eax

	popl %edi		!Restore regs used
	popl %esi

	movl %ebp,%esp		!Standard exit
	popl %ebp
	ret

.align 4
.globl _waitvbl
_waitvbl:
	pushl %edx
	pushl %eax	
	pushl %ebx
	movl $0x3da,%edx
	movl $8,%ebx
waitforstart:		/* wait for flag to show not in a vbl */
	inw %dx,%ax
	andw %bx,%ax
	je waitforstart
read3da:		/* Then wait until vbl starts */
	inw %dx,%ax
	andw %bx,%ax
	jne read3da
	popl %ebx
	popl %eax
	popl %edx
	ret
