/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "animation.h"
extern "C" {
#include <assert.h>
}

slotElt Animation :: sprbank[MAXFRAME];

animElt animElt(int s, int d)
{
	animElt r;
	r.slot=s;
	r.duration=d;
	return r;
}

animList operator+(animElt a, animElt b)
{
	animList l;
	l.append(a); l.append(b);
	return l;
}

animList operator+(animList l, animElt a)
{
	l.append(a);
	return l;
}

Animation::Animation()
{
	animflag=FALSE;
}

Animation::Animation( const Animation& a)
{
	setSlot(a.curslot);
	anim=a.anim;
	curframe=0;
	setAnim(a.getAnim());
}

Animation&
Animation::operator=( const Animation& a)
{
	if( &a == this)
		return *this;

	setSlot(a.curslot);
	anim=a.anim;
	curframe=0;
	setAnim(a.getAnim());
	return *this;
}

void
Animation :: setAnim( bool v )
{
	if( v==TRUE)
	{
		curframe=anim.first();
		animflag=TRUE;
		framecounter=0;
	}
	else
	{
		curframe=0;
		animflag=FALSE;
	}
}

void
Animation :: loadFilm( animList a)
{
	anim=a;
	curframe=anim.first();
}

void
Animation :: doAnim( void )
{

	assert(curframe!=0);
	if(framecounter< anim(curframe).duration)
	{
		setSlot(anim(curframe).slot);
		framecounter++;
	}
	else
	{
		framecounter=0;
		anim.next(curframe);
		if(curframe==0)
			setAnim(FALSE);
		else 
		{
			switch( anim(curframe).slot)
			{
			case LOOPANIM:
				setAnim(TRUE);
				break;
			case VANISHANIM:
				setVisible(FALSE);
				setAnim(FALSE);
				break;
			default:
				setSlot(anim(curframe).slot);
			}
		}
	}
}

void 
Animation :: setSlot(int slot)
{
	assert(slot<MAXFRAME);
	assert(slot>=0);
	curslot=slot;
}
