

proc CreateRegionDlg {} {
    global installdir ybot ytop txbot txheight txname
    toplevel .regdlg
    wm title .regdlg Regions
    wm minsize .regdlg 250 250
    wm geometry .regdlg 250x250
    frame .regdlg.top
    frame .regdlg.middle
    frame .regdlg.middle.middle1
    frame .regdlg.middle.middle2
    frame .regdlg.bot

    label .regdlg.top.flabel -text "Bottom:"
    entry .regdlg.top.fentry -width 5 -textvariable ybot
    label .regdlg.top.blabel -text "Top:"
    entry .regdlg.top.bentry -width 5 -textvariable ytop
    pack .regdlg.top.flabel .regdlg.top.fentry \
	.regdlg.top.blabel .regdlg.top.bentry -side left
    pack .regdlg.top -side top -anchor center

    listbox .regdlg.middle.middle1.box -geometry 10x10 \
	-yscrollcommand ".regdlg.middle.middle1.scroll set" \
	-relief sunken -exportselection false
    scrollbar .regdlg.middle.middle1.scroll -orient vertical \
	-command ".regdlg.middle.middle1.box yview" \
	-relief sunken

    listbox .regdlg.middle.middle2.box -geometry 10x10 \
	-yscrollcommand ".regdlg.middle.middle2.scroll set" \
	-relief sunken -exportselection false
    scrollbar .regdlg.middle.middle2.scroll -orient vertical \
	-command ".regdlg.middle.middle2.box yview" \
	-relief sunken

    button .regdlg.bot.b1 -text Create \
	-command { AddRegion }

    button .regdlg.bot.b2 -text Close \
	-command { wm withdraw .regdlg }

    pack .regdlg.bot.b1 .regdlg.bot.b2 -side left -padx 1c

    pack .regdlg.middle.middle1.box -side left -expand yes -fill both
    pack .regdlg.middle.middle1.scroll -side right -fill y
    pack .regdlg.middle.middle2.box -side left -expand yes -fill both
    pack .regdlg.middle.middle2.scroll -side right -fill y
    pack .regdlg.middle.middle1 -side left -expand yes -fill both
    pack .regdlg.middle.middle2 -side left -expand yes -fill both
    pack .regdlg.middle -side top -expand yes -fill both
    pack .regdlg.bot -side bottom
    UpdateTextures
    tk_listboxSingleSelect .regdlg.middle.middle1.box .regdlg.middle.middle2.box
    bind .regdlg.middle.middle1.box <1> "SelectBRegTexture %W %y"
    bind .regdlg.middle.middle2.box <1> "SelectTRegTexture %W %y"
    wm withdraw .regdlg
}


proc SelectBRegTexture  { w y } {
    global txbot
    $w select from [$w nearest $y]
    set txbot [$w get [$w curselection]]
}

proc SelectTRegTexture  { w y } {
    global txtop
    $w select from [$w nearest $y]
    set txtop [$w get [$w curselection]]
}

proc AddRegion {} {
    global region rindex ybot ytop txbot txtop
    set region($rindex) "$ybot $ytop $txbot $txtop"
    incr rindex
    UpdateRegions
}
