#include "defines.h"
#include "gl.h"
#include "protos.h"
#include "globals.h"

static int helpfont = -1;
static int pausefont = -1;
static int bigfont = -1;
static int statfont = -1;
static int crfont = -1;
static int gameoverfont = -1;

void copyright(void)
{
  int dm = getdrawmode();
  char buffer[20];
  static char *s1="RAWKS v1.03L";
  static char *s2="1994,5 Aaron Hightower";

  drawmode(PUPDRAW);

  if(crfont < 0) crfont = openvecfont(100,60,0.7);
  vmov2(crfont,0.0,-0.95); /* Center bottom */

  color(3);
  vcprint(crfont,s1);
  vcprint(crfont,s2);

  if(!Level || !Level->name) return;
  vmov2(crfont,0.0,0.95); /* Center bottom */
  vmovrel2(crfont,0,-1);

  color(2);
  vcprint(crfont,Level->name);

  sprintf(buffer,"high=%05d (%s)",Mission_list[Selected_mission]->topscore,
				  Mission_list[Selected_mission]->topname);
  color(1);
  vcprint(crfont,buffer);

  drawmode(dm);
}

static void help(int flags)
{
  char buf[80];

  if(helpfont < 0) {
    helpfont = openvecfont(60,30,0.7);
    gameoverfont = openvecfont(10,5,0.7);
  }
  color(1);
  if(Paused) {
    if(pausefont < 0) pausefont = openvecfont(30,15,0.7);
    vmov2(pausefont,0.0,0.0);
    vcprint(pausefont,"* paused *");
    vmov2(helpfont,0.00,-0.25);
    vcprint(helpfont,"press <pause> key or");
    vcprint(helpfont,"click in window");
    vcprint(helpfont,"to resume");
  }
  else if(Game_over) {
    if(flags & OLAY_SOUND) sfx(SFX_INTRO);
/*     if(flags & OLAY_IMAGE) draw_overlay_logo(); */
    if(flags & OLAY_SOUND) sfx(SFX_INTRO);
    if(!(flags & (OLAY_TEXT | OLAY_SCORES))) return;

    vmov2(Mediumfont,0.0,0.0); /* This is for when game is over (BTW) */
    vmovrel2(Mediumfont,0.0,4.0);
    print_cur_high(Mediumfont);

    if(!flags & OLAY_TEXT) return;
    vmov2(gameoverfont,0,0);
    vmovrel2(gameoverfont,0,-1);
    vccprint(gameoverfont,PUPDRAW,0,1,"Game Over");
    vmov2(helpfont,0.00,0.00);
    vmovrel2(helpfont,0.0,-12.0);
    vccprint(helpfont,PUPDRAW,0,2,"<F8> select mission");
    vccprint(helpfont,PUPDRAW,0,1,"<F1>-<F4> for 1-4 player start");
#ifndef __LINUX__
    vccprint(helpfont,PUPDRAW,0,2,"pause key works as advertised");
#endif
    if(Restartable) vccprint(helpfont,PUPDRAW,0,3,"<F5> to restart game");

    vmov2(helpfont,0.0,0.0);
    vmovrel2(helpfont,0.0,5.0);
    sprintf(buf,          "<F6> turns window border %3s",
		      Opts.noborder?"on":"off");
    vccprint(helpfont,PUPDRAW,0,2,buf);

#ifndef NO_SOUND
    if(Has_snd_hardware) {
      sprintf(buf,   "<F7> turns sound effects %3s",
			Opts.nosound?"on":"off");
      vccprint(helpfont,PUPDRAW,0,2,buf);
      vccprint(helpfont,PUPDRAW,0,Opts.nosound?0:2,"+/- control sound volume");
    }
#endif
    vccprint(helpfont,PUPDRAW,0,1,"<F9> preview next level");
/*     vccprint(helpfont,PUPDRAW,0,2,"<F10> more about rawks"); */
/*     vccprint(helpfont,PUPDRAW,0,1,"<F11> level editing"); */
    sprintf(buf,   "<F12> turns doublebuffer %3s",
		      Opts.nodbuff?"on":"off");
    vccprint(helpfont,PUPDRAW,0,1,buf);
  }
}

void draw_overlay_logo(void)
{
  long cur_mode;
  cur_mode = getdrawmode();
  drawmode(PUPDRAW);
  mapcolor(3,0,0,0); /* Do not show redrawing logo */
  gflush();
  color(3);
  map_colors(); /* Restore colors */
  drawmode(cur_mode);
}

void update_overlay(int flags)
{
  drawmode(PUPDRAW);
  if(flags & (OLAY_IMAGE | OLAY_CLEAR | OLAY_SCORES)) clear_overlay();
  ortho2(-1.0,1.0,-1.0,1.0);
#ifdef __LINUX__
  copyright();
#else
  map_colors();
#endif
  help(flags);
  if(Show_high && !Game_over) {
  /* This is at the beginning of each level during game */
    vmov2(Mediumfont,0.0,0.2);
    print_cur_high(Mediumfont);

    if(Speed == INIT_SPEED) { /* Hack to tell if not replaying last level */
      vmov2(Mediumfont,0,-0.2);
      print_prev_high(Mediumfont);
    }
  }
  drawmode(NORMALDRAW);
}

void map_colors(void)
{
  drawmode(PUPDRAW);
  mapcolor(1,0xff,0xff,0x00);
  mapcolor(2,0x00,0xFF,0x00);
  mapcolor(3,0x88,0x88,0x88);
  gflush();
  qtest(); /* Flush */
}

void clear_overlay(void)
{
#ifndef __LINUX__
  int curmode,curmmode;
  Matrix temp;

  curmmode = getmmode();
  mmode(MPROJECTION);
  getmatrix(temp);
  curmode = getdrawmode();
  if(curmode != PUPDRAW) drawmode(PUPDRAW);
  map_colors();
  color(0);
  clear();
  ortho2(-1.0,1.0,-1.0,1.0);
  copyright();
  if(curmode != PUPDRAW) drawmode(curmode);
  loadmatrix(temp);
  mmode(curmmode);
#else
  map_colors();
  color(0);
  clear();
#endif
}

void print_missionname(void)
{
  drawmode(PUPDRAW);
  vmov2(Largefont,0.0,0.75);
  color(1);
  vcprint(Largefont,"Loading mission");
  vmovrel2(Largefont,0.0,1.0);
  color(2);
  vcprint(Largefont,amh_basename(Mission_list[Selected_mission]->name));
  drawmode(NORMALDRAW);
}

void print_levelname(level *l)
{
  char buffer[256];
  int i;

  reshapeviewport();
  if(bigfont < 0) bigfont = openvecfont(30,15,0.7);
  if(statfont < 0) statfont = openvecfont(50,20,0.7);
  drawmode(PUPDRAW);
  clear_overlay();
  mapcolor(2,255,255,255);
  gflush();
  vmov2(bigfont,0.0,0.75);
  color(1);
  vcprint(bigfont,"Loading level");
  color(2);
  if(l->name) vcprint(bigfont,l->name);
  if(l->author) {
    vmov2(statfont,0.0,-0.75);
    color(1);
    vcprint(statfont,"level created by:");
    color(2);
    vcprint(statfont,l->author);
  }
  drawmode(NORMALDRAW);
}
