.TH rawks 6
.SH NAME
rawks \- A space shoot-em-up game for one to four players
.SH SYNOPSIS
.BI rawks
[
.B \-b
]
[
.B \-d
] 
[
.B \-f
] 
[
.B \-g
] 
[
.B \-q
] 
[
.B \-s [xoff,yoff,][xsize,]ysize
] 
.SH DESCRIPTION
.LP
.BI rawks
is a 2d space game with four simple controls: left, right, thrust and fire.
The user may specify which
keys to use to control the craft.  In multi-player mode,
each player chooses which keys will be used to control that craft and
plays simultaneously with the other players.

Multiple crafts are available for flight.  Each craft has different
geometrical characteristics that may make it more or less desirable
for particular missions and/or single or multiple players.

Points are awarded for each object that is destroyed and at the end
of each level based on the time of completion and accuracy for
the level.

No points are awarded for destroying opponents.  In fact, since
destroying your opponent does not cost a life, it can be desirable
to have a friend save you from losing a life by shooting you.

Each level maintains its own high scores in three different categories:
best accuracy, best time, and best score.  If the mission changes for
any reason, the high scores are reset, thus preventing tampering with
data files in order to falsely achieve a high score.  High scores are
also erased if the high score files are modified by any other application
other than
.BI rawks.
.SH OPTIONS
.sp
.BI "\-b"
No border
.sp
.BI "\-d"
Delay loading crafts and sound (preview rocks fast)
.sp
.BI "\-f"
Fullscreen mode (implies noborder)
.sp
.BI "-g"
Go to sinGle buffering by default
.sp
.BI "-q"
Quiet - do not load sound at beginning
.sp
.BI "-s [xoff,yoff,][xsize,]ysize"
.br
Change the size of the window upon invocation.  If only ysize is given,
xsize is set to ysize.  If no offsets are given, the window is
centered.
.LP
.SH CONTROLS
During game play, certain keys are reserved and have functionality
to control different settings in the game.  The F7 key toggles sound
effects.  F6 toggles the window border.  The ESC key will quit the
game if a game is currently in session, or quit the
.BI rawks
application if the game is over.

.SH NOTES
What does rawks stand for?  Well, there is some similarity of some of
the objects to rocks I suppose, but mostly I wanted to get across that
I was using AWK to generate the geometry and executing the data files
to generate the geometry on the fly.  The proper pronunciation is
"rocks" (rhymes with box) with a bit of a southern accent (like billy
joe bob or bubba would say it).


Someone might say that rAWKs stands for "Reconfigurable A****oids With
Kooky Shapes" but I would never confess to having thought of that
myself.

.SH MAKING CUSTOM LEVELS

You can find a customization style startup script in 
.BI rawks.script.
This is good for developing your own levels because you can setup
.BI rawks
to read data from any directory that you want for each different
type of data file.  If you use this startup script, be aware of the
hidden file 
.BI .rawks.opt
that you can use to set commonly used flags
to the game.

If you plan to make your own levels, I suggest that you buy a book
entitled, "the AWK programming language."  This will teach you
plenty about AWK.  You really could figure a lot of it out, and there
is a man page on AWK that you can read.  Also, keep in mind that the
version of AWK to use on the SGI's is called "nawk" and can be found
in /usr/bin/nawk.  See readable rocks in the Rock directory for
some examples.  They should be short and easy to read.

If you make cool rocks, by all means e-mail them to me.  I'll hang
on to them for the next release.  Also, don't forget to send the
level file with your credits in the author field.

The premise of all
data files used by 
.BI rawks
is to execute it if it has executable permission
and read the output.  Otherwise
.BI rawks
just reads it as a normal file.
This way you can write programmable missions and programmable rocks,
or you can just leave the data files if you don't want to give the
(script) source code away.

You can find a description of the rock data format in the Rocks subdirectory.

You can change the sound effects if you want, but the names are hard
coded in this release. (IE you pro'ly don't wanna mess with the sounds...)

If you try to use aifc files, they will work, but there is a nasty clicking
at the beginning.  Use sfconvert to change the format from aifc to aiff.
This will fix the clicking noise.

There is a filter in the "Filters" sub-directory that will process .geom
data files and convert them into rocks.  You can then send the data stream
on to the rotate filter and further animate the rock to rotate like you
want.  You can find examples of how to do this in "Rocks/3d" directory.
This really does not work well for large objects, but if you wanted to make
small 3d objects, it would be easier to do this than to write your own
AWK script to do everything for you.

Be forewarned: processing on .geom and the unusually large rocks takes
a lot of time to complete.  Therefore your levels can take a long time to
load.
It is better to use simple 3d objects and/or do very few frames in the
rotate filter.  Also, you can have missions that have levels that load one
rock at a time to ease the burden of waiting.  It only has to load it the
first time, then it is already in memory for the next level.

The Ships are represented using the same geometry as the rocks.  The
ship-rock is assumed to rotate in the counter-clockwise direction and can
be any number of frames you want.  To make your own ships, try using
drock (found in the Tools directory).  For example:
.sp
  % cd /usr/demos/IndiZone/.data/rawks
  % ./Ships/Classic 1 | ./Tools/drock
.sp
The argument "1" is to hack around an undesirable feature about scaling
ships and rocks.  Without it, the ship appears very very very tiny.

Another way to examine geometry is to modify the geometry currently
being displayed in the game itself and then press pause in the game or
click in the window.  This causes the game to examine the last modified
date of the geometry file, and if it has an outdated version it will auto-
matically reload the newer geometry.  Currently this only works for the
rocks, and not the ships.

Examining geometry from the game gives you a better feel for what the end
result will be.  Drock comes up more quickly and is easier to change from
one rock to the next.

.SH LEVEL MAKING HINTS
.sp
Here are some hints on how to use
.BI rawks
to display your intermediate rocks and missions.

.BI 1)
Put this line in your ~/.Xdefaults
.sp
  4Dwm*keyboardFocusPolicy: explicit

This will allow you to switch windows with the keyboard and will prevent
you from having to go back and forth to use the mouse when building objects.
Once this is in place, and you restart your window manager, you can use
ALT-Tab to switch the focus from one window to the next.  Also keep in mind
that ALT-F5 restores the normal size of a window, ALT-F10 maximizes a
window, ALT-F3 pushes a window and ALT-F1 pops a window.  Check
/usr/people/4Dgifts/.4DWmrc if you have any doubts or if you want to change
these and put them in your own directory.

.BI 2)
rawks examines all data files and reloads updated data files (both rock
geometry and mission files) when it receives a REDRAW event.  This means
that you can use the Push function on your window where you are editing
your rock/mission and it will be pushed behind the rawks screen.  This
will send a REDRAW event to rawks and it will (almost) instantaneously
show you the results of your changes.

.BI NOTE:
This only works when you are not playing the game.  (IE attract
mode).

So you can run the game, select your mission, use F9 to select the
level in the mission, and push the rawks window (presumably by using
ALT-F3) and then go to an xterm/xwsh.  Then pull up the mission file
or rock data file and make your changes and press ALT-F3 to push the
window again, and it will be updates in the rawks game!  (Cool! Huh?!!)

.BI 3)
If you are unsure that your format will work (EG an executable mission
file or something) make sure that you take a look at it like so:
A few examples of stuff I do often:

  % ./Mission/mymission | more

  % ./Rocks/myrock | drock

  % ./Rocks/myrock | more

This will prevent in many instances when you have a bad data file where
.BI rawks
may do something unpredictable.

.sp
.BI 4)
Make sure that all of your levels in your mission load up.  You can
do this (after you make your mission) by pressing F9 and going through
all of the data files until it wraps back to the first level.

.sp
.BI 5)
Don't make rocks that take a long long time to load.  That's annoying (MHO)

.SH SOUND
.BI rawks
will play sound effects on machines with sound capability.  Alternate
sound effects can be used by setting the RAWK_SOUNDDIR environment variable
to a path which contains the following sound files.  Each file should be an
AIFF file with one channel, 16 bit wide data, and 16KHz sound samples.

.LP
.BI 1)
.BI expl_1.aiff
one of three sounds used for explosions
.LP
.BI 2)
.BI expl_2.aiff
one of three sounds used for explosions
.LP
.BI 3)
.BI expl_3.aiff
one of three sounds used for explosions
.LP
.BI 4)
.BI 1.aiff
"player 1"
.LP
.BI 5)
.BI 2.aiff
"player 2"
.LP
.BI 6)
.BI 3.aiff
"player 3"
.LP
.BI 7)
.BI 4.aiff
"player 4"
.LP
.BI 8)
.BI alive.aiff
sound that is played when craft appears on screen
.LP
.BI 9)
.BI fire.aiff
sound used for craft firing
.LP
.BI 10)
.BI bell.aiff
one of three sounds played at beginning of each level
.LP
.BI 11)
.BI congrat.aiff
sound effect played when best time/accuracy/score is achieved
.LP
.BI 12)
.BI game_over.aiff
sound played when game is over
.LP
.BI 13)
.BI sad.aiff
one of three sounds played at beginning of each level
.LP
.BI 14)
.BI thrust.aiff
sound played when player is thrusting
.LP
.BI 15)
.BI mystic.aiff
one of three sounds played at beginning of each level
.LP
.BI 16)
.BI intro.aiff
sound played when game is ready loaded
.LP
.BI 17)
.BI laugh.aiff
unused by game but good as custom sound in a rock
.SH ENVIRONMENT
The following environment variables are used to override the default
directories used by
.BI rawks.
.sp
RAWK_ROCKDIR      - where to find geometry (Rocks)
.br
RAWK_SOUNDDIR     - where to find sounds (Sound)
.br
RAWK_MISSIONDIR   - where to find missions (Mission)
.br
RAWK_HIGHSCOREDIR - where to put high scores (High)
.br

.SH FILES
.br
/usr/demos/IndiZone/rawks,
.br
	    executable
.sp
/usr/demos/IndiZone/.data/rawks/Rocks/*,
.br
	    default geometry files
.sp
/usr/demos/IndiZone/.data/rawks/Mission/*,
.br
	    default mission files
.sp
/usr/demos/IndiZone/.data/rawks/High,
.br
	    default directory to store high scores
.sp
/usr/demos/IndiZone/.data/rawks/Tools,
.br
	    tools & notes to aid in development of levels
.sp
/usr/demos/IndiZone/.data/rawks/Filters,
.br
	    filters to aid in using 3d geometry
.sp
/usr/demos/IndiZone/.data/rawks/Ships,
.br
	    geometry for crafts
.sp
/usr/demos/IndiZone/.data/rawks/3d,
.br
	    3d geometry files
.sp

.nf
.na
.ad
.fi

.SH BUGS
None known.
.SH AUTHOR
.LP
Aaron Hightower, aaron@paradigmsim.com

