# ifndef Mover_h
# define Mover_h

# include "Object.h"

/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
*/

#include "movers.h"
#include "bdash.h"
#include "graphic.h"
#include "io.h"
#include "game.h"

#ifdef ANIMOBJECT
	#include "AnimObject.h"
	#define GOBJECT AnimObject
#else
	#include "GObject.h"
	#define GOBJECT GObject
#endif

extern const void * Mover;

int getxpos (void * _self);
int getypos (void * _self);
int gettype (void * _self);
int getdir (void * _self);
int setdir (void * _self, int dir);
int setxpos (void * _self, int x);
int setypos (void * _self, int y);
int settype (void * _self, int type);
struct Mover * mmove (void * _self, int figurnr, int x1, int y1, int x2, int y2);
struct Mover * mdisplay (void * _self);
struct Mover * animate (void * _self);

extern const void * MoverClass;

#define xpos(a)		((struct Mover *)a)->xpos
#define ypos(a)		((struct Mover *)a)->ypos
#define direction(a)	((struct Mover *)a)->direction

# endif
