/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/

/***********************************************************************

dos_bgi.c:	graphics interface for TurboC's BGI driver

*****************************************************end of header*****/
#include "config.h"

#if defined OS_DOS && CC_TURBOC

#include <stdlib.h>
#include <alloc.h>
#include <mem.h>
#include <dos.h>

#include <graphics.h>
#include "gr_interface.h"

#define TEXTWIDTH(string)	textwidth(string)
#define TEXTHEIGHT(string)	textheight(string)

#define TEXTCOLOR	YELLOW


int graphics_initialized = 0;

int huge DetectSVGA(void) {return SVGA320x200x256;}
/*************************************************************************/

void initgraphics(void)
{
	detectgraph(&gd,&gm);
	if(gd != VGA && gd != IBM8514)
		fatal_error("VGA-Card required");
	gd = DETECT;
	installuserdriver("svga256",DetectSVGA);
	initgraph(&gd,&gm,getenv("BGI")?getenv("BGI"):BGIPATH);
	graphics_initialized = 1;
	gr_maxx = getmaxx(), gr_maxy = getmaxy();
	settextjustify(RIGHT_TEXT,BOTTOM_TEXT);
	setcolor(TEXTCOLOR);
}

void update_graphics(void)	/* no hidden painting, dummy function */
{
}

void leavegraphics(void)
{
	closegraph();
}

void setpalette(DacPalette256 *palette)
{
	setvgapalette(palette);
}

void write_text(int x, int y, char *text)
{
	outtextxy(x,y,text);
}


void _scroll_up(void)
{
  movedata(0xa000,8000,0xa000,0,(size_t)56000L);
}

void _scroll_down(void)
{
  memmove(MK_FP(0xa000,8000),MK_FP(0xa000,0),(size_t)56000L);
}

void _scroll_left(void)
{
  register int y;

  for(y = 0; y < 200; y++)
    movedata(0xa000,y*320+32,0xa000,y*320,288);
}

void _scroll_right(void)
{
  register int y;

  for(y = 0; y < 200; y++)
    memmove(MK_FP(0xa000,y*320+32),MK_FP(0xa000,y*320),288);
}

void display_image(int x, int y, void *buf)
{
	putimage(x,y,buf,COPY_PUT);
}

void gr_line(int a, int b, int c , int d, int color)
{
	setcolor(color);
	line(a,b,c,d);
}

void gr_fillbox(int a, int b, int w, int h, int color)
{
        setfillstyle(SOLID_FILL,color);

        bar(a,b,w,h);
}
/*************************************************************************/
#endif
