#!/bin/sh
#

# usage: restart

#-- options

# You will almost definitely want to change this. In general, it
#  should be the directory this script is in. Provide a full pathname.
GAMEDIR=/usr/local/src/penn/game

# The config file
CONF_FILE=mush.conf

# This is where the general error messages are placed.
LOG=log/pennmush.log

#-- database files

# These names must match those in the conf file.

# You probably want to change this. Usually for a running MUSH, it's indb.Z 
INDB=minimal.db.Z

# This is where the database is dumped to when the game is active.
OUTDB=outdb.Z

# This is the directory and file where panic (crash) databases are placed.
PANICDIR=data
PANICDB=PANIC.db

#-- start up everything

mush=`ps ux | grep pennmush | wc -l`

# Uncomment the following only if you are RUNNING an RWHO server and want to 
# restart it as well
#mwhod=`ps ux | grep mwhod | wc -l`

cd $GAMEDIR

#define Uncomment to following only to restart the RWHO server
#if [ $mwhod -eq 1]; then
#  echo restarting mud who daemon
#  ./mwhod -f muds.dat -n FooWHO >mwhod.log 2>&1 &
#fi

if [ $mush -gt 1 ]; then
  echo Mush already active.
  exit 0
fi

echo Building text file indexes.
./mkindx txt/help.txt txt/help.indx
./mkindx txt/news.txt txt/news.indx
./mkindx txt/events.txt txt/events.indx

echo Restarting Mush.

if [ -r $PANICDIR/$PANICDB ]; then
   end="`tail -1 $PANICDIR/$PANICDB`"
   if [ "$end" = "***END OF DUMP***" ]; then
      mv $PANICDIR/$PANICDB $PANICDIR/temp
      compress $PANICDIR/temp
      mv $PANICDIR/temp.Z data/$OUTDB
      echo "PANIC dump successfully recovered."
   else
      rm $PANICDIR/$PANICDB
      echo "Warning: PANIC dump corrupt. Using older db."
   fi
fi

rm -f save/$INDB.old
mv -f data/$INDB save/$INDB.old
rm -f log/*

if [ -r data/$OUTDB ]; then
   mv data/$OUTDB data/$INDB
else
   echo "No recent database found. Using older database."
   cp save/$INDB.old data/$INDB
fi

./pennmush $CONF_FILE >$LOG 2>&1 &
