#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "nat.h"

struct natstr all[MAXNOC+1];

main()
{
    FILE    *fp, *fopen();
    int     natf, x;
    struct natstr *np;
    char    buf[80], *sprintf();

    if ((fp=fopen("nation.ascii", "w")) == (FILE *)0){
        fprintf(stderr,"Cannot write nation.ascii!\n");
        exit(-1);
    }

    natf = open(sprintf(buf,"%s/nation",DATADIR), O_RDONLY, 0);

    if (natf == -1){
        fprintf(stderr,"Cannot read DATADIR/nation\n");
        exit(-1);
    }

    read(natf, all, sizeof(all));
    close(natf);

    np = all;
    for(x=0;x<MAXNOC;x++,np++)
        write_nation(np, fp);

    fclose(fp);
}

write_nation(np, fp)
struct natstr *np;
FILE *fp;
{
    int x, y, relate, reject, shift;

    for(x=0;x<20;x++)
        fprintf(fp,"%d ",np->nat_cnam[x]);

    for(x=0;x<20;x++)
        fprintf(fp,"%d ",np->nat_pnam[x]);

    fprintf(fp,"%d ",np->nat_xcap);
    fprintf(fp,"%d ",np->nat_ycap);
    fprintf(fp,"%d ",np->nat_xorg);
    fprintf(fp,"%d ",np->nat_yorg);
    fprintf(fp,"%d ",np->nat_stat);
    fprintf(fp,"%d ",np->nat_dayno);
    fprintf(fp,"%d ",np->nat_login);
#ifdef	DEMANDUPDATE
    fprintf(fp,"%d ",np->nat_update);
#endif	DEMANDUPDATE
    fprintf(fp,"%d ",np->nat_tgms);
    fprintf(fp,"%d ",np->nat_minused);
    fprintf(fp,"%d ",np->nat_btu);
    fprintf(fp,"%D ",np->nat_reserve);
    fprintf(fp,"%D ",np->nat_money);
    fprintf(fp,"%D ",np->nat_date);
    fprintf(fp,"%D ",np->nat_newstim);
    for(x=0;x<4;x++)
        fprintf(fp,"%f ",np->nat_level[x]);
    for(x=0;x<MAXNOR;x++){
        fprintf(fp,"%d ",np->nat_b[x].b_xl);
        fprintf(fp,"%d ",np->nat_b[x].b_xh);
        fprintf(fp,"%d ",np->nat_b[x].b_yl);
        fprintf(fp,"%d ",np->nat_b[x].b_yh);
        }
    for(x=0;x<MAXNOC;x++)
        fprintf(fp,"%d ",np->nat_relate[x]);
#ifdef	REJECTS				/* 3/17/90 bailey@mcs.kent.edu */
    for(x=0;x<MAXNOC;x++)
        fprintf(fp,"%d ",np->nat_rejects[x]);
#endif	REJECTS

    fprintf(fp,"\n");
}
