#include <stdio.h>
#include <fcntl.h>

#include "gamesdef.h"
#include "misc.h"

#if	defined(BMAP) || defined(AUTONAV)

#define MAXROUTE	300	   /* return '?' if path longer than this */
#define WORLDSIZE	WORLD_X*WORLD_Y/2
#define normalize(i,j)	((i+j)%j)
#define valid(x,y)	(((x^y)&1)==0)
#define stype(x,y)   	bigmap[(x/2)*WORLD_Y+y]

int bigmapf;
char bigmap[WORLDSIZE];
char bigmapfil[] = EMPPATH(data/bigmap);

/* ________________________________________________________________
**
** bigmap file utilities
** ________________________________________________________________
*/

openbigmap(cnum)
int cnum;
{
  char name[80];
  int i;
  sprintf(name,"%s%02d",bigmapfil,cnum);
  bigmapf=open(name, O_CREAT | O_RDWR, 0600);
  for (i=0;i<WORLDSIZE;i++) bigmap[i]=' ';
  if (bigmapf>=0) read(bigmapf, bigmap, WORLDSIZE);
}

closebigmap()
{
  if (bigmapf>=0) close(bigmapf);
  bigmapf = -1;
}

writebigmap()
{
  if (bigmapf>=0) {
    lseek(bigmapf, 0L, 0);
    write(bigmapf, bigmap, WORLDSIZE);
  }
}

setbigmap(x,y,t)
int x,y;
char t;
{
  if (t == NULL)
	return;
  x  = normalize(x,WORLD_X);
  y  = normalize(y,WORLD_Y);
  if (valid(x,y)) {
    if (t == '?') {
      switch(stype(x,y)) {
      case '.':
      case '-':
      case ' ':
        stype(x,y) = t;
	break;
      }
    }
    else
      stype(x,y) = t;
  }
}

char getbigmap(x,y)
int x,y;
{
  x  = normalize(x,WORLD_X);
  y  = normalize(y,WORLD_Y);
  return(valid(x,y) ? stype(x,y) : (char)0 );
}

#endif
