.TH Concept "Ship Types"
Some of the ships currently available in Empire are:
.s3
.NF
torpedo-boat	
patrol boat	These ships have been misrepresented in Empire. They were
		designed to kill large ships by swarming them and launching
		torpedos. In fact, they were projected to be so effective
		that the French 'Jeune Ecole' (Young School) of naval officers
		advocated abandoning battleships entirely, saying that they
		would be helpless in the face of the torpedo-boat. In reality,
		the torpedo boat was limited by it's short range, deficient
		sea-keeping ability, and the battleship's quick acquisition of
		numerous light quick-firing guns and machine guns. They were
		effective when used in large numbers, but tended to die a lot.

destroyer	These include three kinds of ships. First is the 1880-1910
		destroyers, originally 'torpedo-boat destroyers', and meant to
		be cheap ships to screen the battleships. Second is the
		1910-1950 version, meant to kill submarines with sonar and
		depth-charges. Lastly is the 1950-1965 destroyer, an all around
		ship, with ASW and ASuW (anti-surface armament). After that,
		they type mostly died out, as it had gotten too large.

frigate		Originally, these were ships of about 200-400t, with a crew
		of 200-500, armed with from 30-50 large cannon plus numerous
		small cannon. They were intended to scout for ships of the
		line, and protect/destroy commerce. After about 1860, the type
		died out entirely, and was replaced by light cruisers. In the
		1960's, the type was ressurrected for a new class of ASW (anti
		submarine warfare) ships of small-medium size.

light cruiser	The class came into existence in the 1860-1905 period to provide
		fast ships suitable for extended deployment in far-away places.
		They were intended to out-class local defense boats, and not
		much else. Much was sacrificed to give them long-term speed
		end endurance. They were not intended to have a role in a major
		battle.

heavy cruiser	This class has a dual role. It was intended to re-inforce the
		light cruisers in the colonies, providing a heavier punch and
		more armor, and also to be scouting elements in major fleet
		battles.

ship-of-the-line
pre-dreadnought
dreadnought
battleship	While the names change, the purpose remained the same: a ship
		that brings heavy guns close to the enemy and destroys him. It
		also was much used for off-shore bombardmment, and for ships
		of the line, minor invasions. (A complement of 300-400 marines
		and 600 sailors allowed a ship of the line to land up to 750
		fighting men at any desired point. Small squadrons of these
		ships could (and did) take over towns, attack fortresses by
		surprise, and generally make life miserable for the defense)
		
		The pre-dreadnought was a battleship with a limited number
		(usually 4) of heavy guns, numerous lighter guns ('secondary'
		and 'tertiary' armament), and heavy armor on vital portions
		of the ship. They were hard to kill, even for themselves, as
		they had only a few guns that could penetrate the armor of
		their peers.

		The dreadnought was introduced in an article in Jane's Fighting
		Ships by an Italian designer, who receive permission to publish
		his design after the Italian government decided that it was
		too large and expensive for them. The design/concept was seized
		upon by First Sea Lord Jacky Fisher, who rushed completion of
		the first ship, the Dreadnought, through in only 1 year. (An
		amazing feat and a major record) The Dreadnought gave its
		name to the entire type of ship, having 8-12 large calibre
		guns, few secondary & tertiary weapons, and good armor. (As
		can be guessed, the threat posed by torpedo boats had diminished
		considerably, mostly with the quiet abandonment of the policy
		of close blockade, and the advent of the destroyer)

		The battleship of the 1918-1945 period was faster, and carried
		a new AA capacity, especially in the latter years of the period.
		
		After 1945, the class died out (except for 4 ships)

		For our purposes, a battleship 1 is a ship of the line, a
		battleship 2 is a pre-dreadnought, a battleship 3 is a
		dreadnought, and a battleship 4 is what was called a battleship
		or (sometimes) super-dreadnought.

battlecruiser	These special ships existed in the 1905-1920 period, prior to
		the widespread intoduction of oil fuel. They had full battle-
		ship guns, and a large speed advantage over the battleships,
		but very little armor. They were initially the pet project of
		First Sea Lord Jacky Fisher, who intended them to both kill
		the heavy/armored cruisers of the time, and to scout for the
		battleships. With their heavy armament (and name), their
		function inevitably blurred, and they were used in combat
		against full-fledged battleships, where they died like flies.
		With this (and with the introduction of oil fuel, which made
		battleships their equal in speed), they were phased out.

ASW cruiser	These ships came into being in the 1965-present period in 
		response to a need for a large ASW ship to carry ASW helicopters
		and command equipment. It typically carries full ASW armament,
		as well as a minor ASuW capability.

missile boat
missile frigate
missile cruiser	These ships range in size from 100t missile boats (the modern
		replacement for the torpedo-boat) to the 6000-8000t missile
		cruiser. They all are designed to bring missiles to bear on
		the enemy. (The first successful missile boats were Egyptian,
		and used againt the Israelis in the 1967 Arab-Israeli war)

		The missile frigate and cruiser also serve as SAM ships.

landing craft	These ships are relatively unique, being used only in the 1942-
		1950 period. Before that, landings were carried out by frigates,
		ships-of-the-line, light & heavy cruisers, & pre-dreadnoughts,
		all of which could land a large number of men. With th
		introduction of the concept of beach-defense by the Germans,
		these ships were invented to get large numbers of men on the
		beaches quickly. After 1950, their functions were largely
		assumed by the helicopter.

aircraft carrier
light carrier
escort carrier	These ships are designed for various purposes. At first,
		carriers concentrated on scouting for the battleships. Later,
		it was proved that airplanes could sink battleships (Thanks to
		Billy Mitchell here), and the emphasis moved to all-around sea
		control. Still later, with the dissapearance of the battleship,
		a large power-projection capacity was added.

		Light carriers were simply smaller versions of the large or
		'fleet' carriers, and were used for the same duties.

		Escort carriers were usually hastily converted merchantmen,
		and carried small numbers of fighters and ASW planes. (Some
		merchantment, in fact, were equipped with 1 fighter and a
		temporary catapault. When threatened by enemy planes, the
		fighter took off. When it was done, it ditched, and the pilot
		was (theoretically) picked up by the merchant ship's convoy.
		This was used several times, and worked!)

submarine	The submarine was originally intended, in the 1900-1910 period,
		to fille the same role as the torpedo boat, using stealth to
		get to the battleships instead of speed. It was a strictly
		defensive weapon, without much speed or endurance. 

		In the 1910-1925 period, the sub was much enlarged, and use in
		a combination anti-battleship (sank at least 20)/anti-commerce
		role. Endurance was much improved, and the sub could now
		operate a long distance from its home port.

		In the 1925-1945 period, the sub steadily grew large and more
		capable, gaining mostly in speed, sonar ability, and endurance.

		After 1945, nuclear power vastly increased the subs endurance,
		making it effectively infinite. Sonar was also vastly improved,
		and removed the reliance upon the periscope. The subs armament
		was also vastly improved with the addition of the SLM & SLBM.

minesweeper	Usually converted fishing vessels, small, and expendable. They
		found and destroyed mines with a variety of tricks, including
		cables & magnetism.

oiler		These ships represent the whole range of refuelling ships.
.FI
.s1
These ship types differ in their fundamental
capabilities; some can fire guns, some cannot;
each has it's own specific abilities & roles.
The capabilities of each ship are given by the show command.
The headings are as follows. For the building data:
.s3
.in \w'tech\0\0'u
.L lcm
The lcm required to build the ship.
.L hcm
The hcm required to build the ship.
.L tech
The minimum technology required to build the ship.
.L $
The cost of the ship.
.in \\n(in
.s1
The headings for the capability listing are
.s1
.in \w'fir\0\0'u
.L def
defensive armament of the ship
.L spd
the distance/mu for moving (in relative units)
.L vis
how visible the ship is, (relative units)
.L spy
how far the ship can see, (i.e. how good the
communication equipment is), again in relative units
.L rng
twice the distance the guns can fire,
(assuming a high technology level)
The range formula is (rng/2) * (tech + 50) / (tech + 200)
.L fir
the number of guns the ship can fire at once
.L hel
The number of helicopters the ship can carry. (If the SHIPCHOPPER option is
enabled)
.L xpl
The number of xtra-light planes the ship can carry. (If the XLIGHT option is
enabled)
.L pln
The number of light planes the ship can carry.
.L fuel c/u
The ship's fuel capacity & useage. (see info fuel) (If the FUEL option is
enabled)
.in
.s3
Each ship can carry a certain amount of products and has certain
capabilities. These are listed under the cargoes & abilities section.
The cargoes give the number of each product that can be carried.
The abilities are as follows.
.s1
.in \w'sonar\0\0'u
.L fish
The vessel will accumulate food by fishing
.L torp
The vessel can fire torpedos.
.L dchrg
The vessel can drop depth charges
.L plane
The vessel can carry planes with the light attribute set.
.L miss
The vessel can carry missiles.
.L oil
The vessel can drill for oil
.L sonar
The vessel has sonar capabilities to detect submarines
.L mine
The vessel can lay mines
.L sweep
The vessel can sweep the sector for mines and recover them
.L sub
The vessel is a submarine
.L spy
The vessel can engage in spying activities
.L land
The vessel can be used as a landing craft. (see info assault)
.L semi-land
The vessel can be used as a semi-landing craft. (see info assault)
.L sub-torp
The vessel can torpedo submarines
.L trade
The vessel is a trade ship. (only if TRADESHIPS are enabled)
.L
.in
.s3
Some examples of the output:
.s1
.EX show ship build
.NF
                          lcm hcm avail tech  $
fishing boat 1             25  15    12    0 $300
cargo ship 1               60  40    29    0 $500
ore ship 1                 60  40    29    0 $500
slave ship 1               60  40    29    0 $500
passenger ship 1           60  40    29    0 $500
trade ship 1              200 100    81    0 $2500
frigate                    30  30    19    0 $600
battleship 1               50  50    31    0 $800
.FI
.s3
.EX show ship cap
.NF
                   s  v s  r  f  c  x  p fuel
                   p  i p  n  i  h  p  l  c/u
              def  d  s y  g  r  p  l  n      cargoes & abilities
fishing boat   10 15 15 2  0  0  0  0  0   0/0  300c 10m 900f 15u fish
cargo ship 1   20 15 35 3  0  0  0  1  0   0/0  600c 50m 300s 50g 900f 1400l 900
h 250u
ore ship 1     20 15 35 3  0  0  0  1  0   0/0  30c 5m 990i 990d 200f 45u 990r
slave ship 1   20 15 35 3  0  0  0  1  0   0/0  20c 80m 200f 1200u
passenger shi  20 15 35 3  0  0  0  1  0   0/0  350c 15m 700f
trade ship 1   20 15 35 3  0  0  0  1  0   0/0  50c 50m 100f trade
.FI
.s3
See also : coastwatch, fire, load, lookout, mine, navigate, tend, 
torpedo, fly, show, trade-ships
