# makeicon.tcl --
#
#

proc InitMainWindow {} {

	set win .makeicon
	toplevel $win
	wm title $win "Convert Image To Icon File"

	frame $win.frameSrc \
		-borderwidth 0
	frame $win.frameDst \
		-borderwidth 0

	set frame $win.frameSrc
	label $frame.labelSrc \
		-text "Image File:" -anchor w
	entry $frame.entrySrc \
		-width 60
	button $frame.buttonSrc \
		-text "Browse..." -command "ChooseFile Open $frame.entrySrc"

	set frame $win.frameDst
	label $frame.labelDst \
		-text "Target Icon File:" -anchor w
	entry $frame.entryDst \
		-width 60
	button $frame.buttonDst \
		-text "Browse..." -command "ChooseFile Save $frame.entryDst"

	set frame $win.frameSrc
	pack $frame \
		-side top -padx 5 -pady 5
	pack $frame.labelSrc \
		-in $frame -side top -padx 5 -anchor w
	pack $frame.entrySrc \
		-in $frame -side left -padx 5
	pack $frame.buttonSrc \
		-in $frame -side left -padx 5

	set frame $win.frameDst
	pack $frame \
		-side top -padx 5 -pady 5
	pack $frame.labelDst \
		-in $frame -side top -padx 5 -anchor w
	pack $frame.entryDst \
		-in $frame -side left -padx 5
	pack $frame.buttonDst \
		-in $frame -side left -padx 5

	frame $win.divider \
		-borderwidth 1 -height 2 -relief sunken
	pack $win.divider \
		-side top -fill x -padx 10 -pady 5

	set frame $win.frameButtons
	frame $frame \
		-borderwidth 0
	button $frame.cancel \
		-text Done -width 9 -command "destroy $win"
	button $frame.begin \
		-text Begin -width 9 -command DoIt

	pack $frame \
		-side top -padx 5 -pady 0 -anchor e
	pack $frame.cancel \
		-side right -padx 5 -pady 5
	pack $frame.begin \
		-side right -padx 5 -pady 5

	# Defaults
	set path [file split [pwd]]
	set path [file dirname [pwd]]
	set src [file join $path image feature.gif]
	set src [file nativename $src]
	set dst [file join $path image feature.icd]
	set dst [file nativename $dst]
	$win.frameSrc.entrySrc insert 0 $src
	$win.frameDst.entryDst insert 0 $dst
	focus $win.frameSrc.entrySrc
}

proc ChooseFile {mode entry} {

	set types {
		{"All files"	*}
	}

	set filePath [tk_get${mode}File -filetypes $types -parent .makeicon]
	if {$filePath != {}} {
		$entry delete 0 end
		$entry insert 0 [file nativename $filePath]
	}
}

proc DoIt {} {

	set win .makeicon

	set imageFile [eval file join [file split [$win.frameSrc.entrySrc get]]]
	if ![file exists $imageFile] {
		tk_messageBox -icon error -parent $win -title "File Error" \
			-message "The source file \"$imageFile\" does not exist!"
		return
	}

	set iconFile [eval file join [file split [$win.frameDst.entryDst get]]]
	if [file exists $iconFile] {
		set extension [file extension $iconFile]
		if {[string compare $extension ".icd"] && [string compare $extension ".msk"]} {
			set choice [tk_messageBox -icon question -type yesno -parent $win \
				-message "Really overwrite \"$iconFile\"?"]
			if {$choice == "no"} return
		}
	}

	if [catch {
		exec makeicon 32 $imageFile $iconFile
	} result] {
		tk_messageBox -icon warning -parent $win -title "MakeIcon Error" \
			-message $result
	}
}

wm withdraw .
InitMainWindow
bind .makeicon.frameSrc.entrySrc <Destroy> exit
