/* File: gredit.c   Main routine for graphics editor
 * 
 * Based on chredit.pas
 */

/*
 * Copyright (c) 1991-1996 Mike Marcelais
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>

#ifdef __WATCOMC__
#include <graph.h>
#else
#include "graph.c"
#endif

/* Definitions */

typedef unsigned char byte;
typedef byte FontTable[256][16];

enum {DIR_WHO_CARES = 0, DIR_UP, DIR_DOWN, DIR_LEFT, DIR_RIGHT};

enum {KEY_HOME = 'G', KEY_UP = 'H', KEY_PGUP = 'I',
      KEY_RIGHT= 'M', KEY_LEFT = 'K',
      KEY_END  = 'O', KEY_DN = 'P', KEY_PGDN = 'Q'};

const short MAXMENU = 5;

typedef struct XlateRec {
   short xloc;
   short yloc;
   short next;
   short prev;
} XlateRec;

const XlateRec __xlate[261] =
                   /*- 5*/{{300,190,- 1,- 4},  /* Text */
                           {300,180,- 5,- 3},  /* Terrain */
                           {300,170,- 4,- 2},  /* Stores */
                           {300,160,- 3,- 1},  /* Monsters */
                           {300,150,- 2,- 5},  /* Items */

                   /*  0*/ {  0,  0,  0,  0},
  
                           {300,150,130,160},  /* Items */
                           {300,150,165,252},  /* Monsters */
                           {300,150,195,202},  /* Stores */
                           {300,150,205,224},  /* Terrain */
                   /*  5*/ {300,130, 32,126},  /* Text */

                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /* 10*/ {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /* 15*/ {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /* 20*/ {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /* 25*/ {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /* 30*/ {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
  
                           {300,140, 33,  5},
                           {300,150, 34, 32},
                           {300,160, 35, 33},
                   /* 35*/ {300,170, 36, 34},
                           {300,180, 37, 35},
                           {300,190, 38, 36},
                           {300,200, 39, 37},
                           {300,210, 40, 38},
                   /* 40*/ {300,220, 41, 39},
                           {300,230, 42, 40},
                           {300,240, 43, 41},
                           {300,250, 44, 42},
                           {300,260, 45, 43},
                   /* 45*/ {300,270, 46, 44},
                           {300,280, 47, 45},
                           {300,290, 48, 46},
                           {300,300, 49, 47},
                           {300,310, 50, 48},
                   /* 50*/ {300,320, 51, 49},
                           {300,330, 52, 50},
                           {300,340, 53, 51},
                           {300,350, 54, 52},
                           {300,360, 55, 53},
                   /* 55*/ {300,370, 56, 54},
                           {300,380, 57, 55},
                           {300,390, 58, 56},
                           {300,400, 59, 57},
                           {300,410, 60, 58},
                   /* 60*/ {300,420, 61, 59},
                           {300,430, 62, 60},
                           {300,440, 63, 61},
                           {400,130, 64, 62},
                           {400,140, 65, 63},
                   /* 65*/ {400,150, 66, 64},
                           {400,160, 67, 65},
                           {400,170, 68, 66},
                           {400,180, 69, 67},
                           {400,190, 70, 68},
                   /* 70*/ {400,200, 71, 69},
                           {400,210, 72, 70},
                           {400,220, 73, 71},
                           {400,230, 74, 72},
                           {400,240, 75, 73},
                   /* 75*/ {400,250, 76, 74},
                           {400,260, 77, 75},
                           {400,270, 78, 76},
                           {400,280, 79, 77},
                           {400,290, 80, 78},
                   /* 80*/ {400,300, 81, 79},
                           {400,310, 82, 80},
                           {400,320, 83, 81},
                           {400,330, 84, 82},
                           {400,340, 85, 83},
                   /* 85*/ {400,350, 86, 84},
                           {400,360, 87, 85},
                           {400,370, 88, 86},
                           {400,380, 89, 87},
                           {400,390, 90, 88},
                   /* 90*/ {400,400, 91, 89},
                           {400,410, 92, 90},
                           {400,420, 93, 91},
                           {400,430, 94, 92},
                           {400,440, 95, 93},
                   /* 95*/ {500,130, 96, 94},
                           {500,140, 97, 95},
                           {500,150, 98, 96},
                           {500,160, 99, 97},
                           {500,170,100, 98},
                   /*100*/ {500,180,101, 99},
                           {500,190,102,100},
                           {500,200,103,101},
                           {500,210,104,102},
                           {500,220,105,103},
                   /*105*/ {500,230,106,104},
                           {500,240,107,105},
                           {500,250,108,106},
                           {500,260,109,107},
                           {500,270,110,108},
                   /*110*/ {500,280,111,109},
                           {500,290,112,110},
                           {500,300,113,111},
                           {500,310,114,112},
                           {500,320,115,113},
                   /*115*/ {500,330,116,114},
                           {500,340,117,115},
                           {500,350,118,116},
                           {500,360,119,117},
                           {500,370,120,118},
                   /*120*/ {500,380,121,119},
                           {500,390,122,120},
                           {500,400,123,121},
                           {500,410,124,122},
                           {500,420,125,123},
                   /*125*/ {500,430,126,124},
                           {500,440,  5,125},
  
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
  
                   /*130*/ {300,160,131,  1},
                           {300,170,132,130},
                           {300,180,133,131},
                           {300,190,134,132},
                           {300,200,135,133},
                   /*135*/ {300,210,136,134},
                           {300,220,137,135},
                           {300,230,138,136},
                           {300,240,139,137},
                           {300,250,140,138},
                   /*140*/ {300,260,141,139},
                           {300,270,142,140},
                           {300,280,143,141},
                           {300,290,144,142},
                           {300,300,145,143},
                   /*145*/ {450,150,146,144},
                           {450,160,147,145},
                           {450,170,148,146},
                           {450,180,149,147},
                           {450,190,150,148},
                   /*150*/ {450,200,151,149},
                           {450,210,152,150},
                           {450,220,153,151},
                           {450,230,154,152},
                           {450,240,155,153},
                   /*155*/ {450,250,156,154},
                           {450,260,157,155},
                           {450,270,158,156},
                           {450,280,159,157},
                           {450,290,160,158},
                   /*160*/ {450,300,  1,159},
  
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},

                   /*165*/ {300,160,166,  2},
                           {300,170,167,165},
                           {300,180,168,166},
                           {300,190,169,167},
                           {300,200,170,168},
                   /*170*/ {300,210,171,169},
                           {300,220,172,170},
                           {300,230,173,171},
                           {300,240,174,172},
                           {300,250,175,173},
                   /*175*/ {300,260,176,174},
                           {300,270,177,175},
                           {300,280,178,176},
                           {300,290,179,177},
                           {300,300,180,178},
                   /*180*/ {300,310,181,179},
                           {300,320,182,180},
                           {300,330,183,181},
                           {300,340,184,182},
                           {300,350,185,183},
                   /*185*/ {300,360,186,184},
                           {300,370,187,185},
                           {300,380,188,186},
                           {300,390,189,187},
                           {300,400,190,188},
                   /*190*/ {300,410,225,189},
  
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},

                   /*195*/ {300,160,196,  3},
                           {300,170,197,195},
                           {300,180,198,196},
                           {300,190,199,197},
                           {300,200,200,198},
                   /*200*/ {300,210,201,199},
                           {300,220,202,200},
                           {300,230,  3,201},
  
                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
  
                   /*205*/ {300,160,206,  4},
                           {300,170,207,205},
                           {300,180,208,206},
                           {300,190,209,207},
                           {300,200,210,208},
                   /*210*/ {300,210,211,209},
                           {300,220,212,210},
                           {300,230,213,211},
                           {300,240,214,212},
                           {300,250,215,213},
                   /*215*/ {300,260,216,214},
                           {300,270,217,215},
                           {300,280,218,216},
                           {300,290,219,217},
                           {300,300,220,218},
                   /*220*/ {300,310,221,219},
                           {300,320,222,220},
                           {300,330,223,221},
                           {300,340,224,222},
                           {300,350,  4,223},

                   /*225*/ {450,160,226,190},
                           {450,170,227,225},
                           {450,180,228,226},
                           {450,190,229,227},
                           {450,200,230,228},
                   /*230*/ {450,210,231,229},
                           {450,220,232,230},
                           {450,230,233,231},
                           {450,240,234,232},
                           {450,250,235,233},
                   /*235*/ {450,260,236,234},
                           {450,270,237,235},
                           {450,280,238,236},
                           {450,290,239,237},
                           {450,300,240,238},
                   /*240*/ {450,310,241,239},
                           {450,320,242,240},
                           {450,330,243,241},
                           {450,340,244,242},
                           {450,350,245,243},
                   /*245*/ {450,360,246,244},
                           {450,370,247,245},
                           {450,380,248,246},
                           {450,390,249,247},
                           {450,400,250,248},
                   /*250*/ {450,410,251,249},
                           {450,420,252,250},
                           {450,430,  2,251},

                           {  0,  0,  0,  0},
                           {  0,  0,  0,  0},
                   /*255*/ {  0,  0,  0,  0}};

const XlateRec *xlate = __xlate+5;  /* So that array starts at xlate[-5] */

/* Global Values */

FontTable chars;
char filename[256];

/* Graphics Definition functions */

const char *code(short symbol)
{
   static char __buffer[32];

   switch(symbol) {
      case  -5: return("Text");

      case  -4: return("Terrain");
      case  -3: return("Stores");
      case  -2: return("Monsters");
      case  -1: return("Items");
      case   1: return("Main Menu");
      case   2: return("Main Menu");
      case   3: return("Main Menu");
      case   4: return("Main Menu");
      case   5: return("Main Menu");

      case 130: return("Amulets");
      case 131: return("Arkenstone");
      case 132: return("Armor");
      case 133: return("Books");
      case 134: return("Boots");
      case 135: return("Chests");
      case 136: return("Cloak");
      case 137: return("Food");
      case 138: return("Gloves");
      case 139: return("Helmet");
      case 140: return("Junk");
      case 141: return("Lamp");
      case 142: return("Missle ammo");
      case 143: return("Missle shooters");
      case 144: return("Mushrooms");
      case 145: return("Phial");
      case 146: return("Potions");
      case 147: return("Rings");
      case 148: return("Rods");
      case 149: return("Scrolls");
      case 150: return("Shields");
      case 151: return("Shovels/Picks");
      case 152: return("Skeletons");
      case 153: return("Spikes");
      case 154: return("Staffs");
      case 155: return("Star");
      case 156: return("Torch");
      case 157: return("Wands");
      case 158: return("Weapons, Edged");
      case 159: return("Weapons, Polearm");
      case 160: return("Weapons, Hafted");

      case 165: return("Angel");
      case 166: return("Bird");
      case 167: return("Canine");
      case 168: return("Dragon (Ancient)");
      case 169: return("Elemental");
      case 170: return("Dragon Fly");
      case 171: return("Ghost");
      case 172: return("Hybrid");
      case 173: return("Insect");
      case 174: return("J");
      case 175: return("Killer Beetle");
      case 176: return("Lich");
      case 177: return("M-H Reptile");
      case 178: return("N");
      case 179: return("Ogre");
      case 180: return("Giant Humanoid");
      case 181: return("Quylthulg");
      case 182: return("Reptile");
      case 183: return("Spider");
      case 184: return("Troll");
      case 185: return("Major Demon");
      case 186: return("Vampire");
      case 187: return("Wight/Wraith");
      case 188: return("Xorn");
      case 189: return("Yeti");
      case 190: return("Zephyr Hound");

      case 195: return("General Store");
      case 196: return("Armor Store");
      case 197: return("Weapon Store");
      case 198: return("Temple");
      case 199: return("Alchemist");
      case 200: return("Magic Store");
      case 201: return("Black Market");
      case 202: return("Home");

      case 205: return("Closed door");
      case 206: return("Down staircase");
      case 207: return("Gems");
      case 208: return("Glyph");
      case 209: return("Gold");
      case 210: return("Gold in Magma");
      case 211: return("Gold in Quartz");
      case 212: return("Granite Wall");
      case 213: return("Jammed Door");
      case 214: return("Locked Door");
      case 215: return("Magma Wall");
      case 216: return("Open Door");
      case 217: return("Open Space");
      case 218: return("Quartz Wall");
      case 219: return("Rubble");
      case 220: return("Trap (dart)");
      case 221: return("Trap (gas)");
      case 222: return("Trap (pit)");
      case 223: return("Trap (rune)");
      case 224: return("Up staircase");

      case 225: return("Ant");
      case 226: return("Bat");
      case 227: return("Centipede");
      case 228: return("Dragon");
      case 229: return("Eye");
      case 230: return("Feline");
      case 231: return("Golem");
      case 232: return("Hobbit/elf/dwarf");
      case 233: return("Icky Thing");
      case 234: return("Jelly");
      case 235: return("Kobold");
      case 236: return("Louse");
      case 237: return("Mold");
      case 238: return("Naga");
      case 239: return("Orc");
      case 240: return("Person");
      case 241: return("Quadruped");
      case 242: return("Rodent");
      case 243: return("Skeleton");
      case 244: return("Townsperson");
      case 245: return("Minor Daemon");
      case 246: return("Vortex");
      case 247: return("Worm Mass");
      case 248: return("x");
      case 249: return("Yeek");
      case 250: return("Zombie");
      case 251: return("You");
      case 252: return("Mushrooms");
      default:  if ((symbol >= 32) && (symbol <= 126))
                   {
                   sprintf(__buffer, "Text: %c",symbol);
                   return(__buffer);
                   };
                return("۲");
      };
};

void massage(char *s)
{
   short i;

   for(i=0;i<strlen(s);i++)
      s[i] = toupper(s[i]);

   for(i=0;i<strlen(s);i++)
      while((s[i]<' ') || ((s[i]==' ') && (s[i+1]==' ')))
         memmove(s+i,s+i+1,strlen(s)-i-1);

   while(*s==' ')
      memmove(s,s+1,strlen(s)-1);

   while(s[strlen(s)-1]==' ')
      s[strlen(s)-1]=0;
};

void prepend(const char *prefix, char *msg)
{
   memmove(msg+strlen(prefix),msg,strlen(msg));
   memcpy(msg,prefix,strlen(prefix));
};

void drawrow(byte bitmap, short color, short x, short y)
{
   short i;

   for(i=7;i>=0;i--)
      {
      _setcolor(bitmap & 0x01 ? color : 0);
      _setpixel(x+i,y);
      bitmap >>= 1;
      };
};

void drawchr(short chr, short color, short x, short y)
{
   short i;

   for(i=0;i<16;i++)
      drawrow(chars[chr][i],color,x,y+i);
};

#define logo()                                        \
   printf("Bitmap Graphics Editor (Version 3.0c)\n"   \
          "Written for Angband 2.7.9v5\n"             \
          "Copyright 1991-1996 by Mike Marcelais\n"   \
          "Another 4th Bryan Production...\n");       \

void putmessage(short colorx)
{
   _setcolor(colorx);
   _moveto(0,0);
   _outgtext("Bitmap Graphics Editor (Version 3.0c)");
   _moveto(0,10);
   _outgtext("Written for Angband 2.7.9v5");
   _moveto(0,20);
   _outgtext("Copyright 1991-96 Mike Marcelais");
   _moveto(0,30);
   _outgtext("Another 4th Bryan Production...");
};

void shutdown(void)
{
   _setvideomode(_DEFAULTMODE);
   _clearscreen(_GCLEARSCREEN);
   logo();
   exit(0);
};

void initgraphics(short colorx)
{
   if (_setvideomode(_VRES16COLOR))
      {
      _setvideomode(_DEFAULTMODE);
      printf("VGA found\n");
      delay(2000);
      _setvideomode(_VRES16COLOR);
      putmessage(colorx);
      return;
      };

   _clearscreen( _GCLEARSCREEN );
   printf("VGA not found.\n"
          "VGA is required to run this editor and to get graphics support\n"
          "in Angband.\n\n");
   logo();
   exit(1);
};

short fexist(const char *name)
{
   FILE *f = fopen(name, "rb");
   if (f)
      fclose(f);
   return(f!=NULL);
};

void getchars(void)
{
   FILE *f = fopen(filename, "rb");
   fread(chars,4096,1,f);
   fclose(f);
};

void savechars(void)
{
   FILE *f = fopen(filename, "wb");
   fwrite(chars,4096,1,f);
   fclose(f);
};

void importchar(short c, const char *name)
{
   FontTable impfont;
   FILE *f = fopen(name, "rb");
   fread(impfont,4096,1,f);
   fclose(f);
   memcpy(chars+c,impfont+c,16);
};

char idwhich(char **s)
{
   if (strncmp("BORDER=",*s,7)==0)
      {
      *s+=7;
      return('B');
      };
   if (strncmp("CURSOR=",*s,7)==0)
      {
      *s+=7;
      return('C');
      };
   if (strncmp("FILL=",*s,5)==0)
      {
      *s+=5;
      return('F');
      };
   if (strncmp("TEXT=",*s,5)==0)
      {
      *s+=5;
      return('X');
      };
   if (strncmp("TILE=",*s,5)==0)
      {
      *s+=5;
      return('T');
      };
   return(' ');
};

short idcolor(const char *s)
{
   if ((strcmp("BLACK",s)==0) || (strcmp("0",s)==0))
      return(0);
   if ((strcmp("BLUE",s)==0) || (strcmp("1",s)==0))
      return(1);
   if ((strcmp("GREEN",s)==0) || (strcmp("2",s)==0))
      return(2);
   if ((strcmp("CYAN",s)==0) || (strcmp("3",s)==0))
      return(3);
   if ((strcmp("RED",s)==0) || (strcmp("4",s)==0))
      return(4);
   if ((strcmp("MAGENTA",s)==0) || (strcmp("5",s)==0))
      return(5);
   if ((strcmp("BROWN",s)==0) || (strcmp("6",s)==0))
      return(6);
   if ((strcmp("GREY",s)==0) || (strcmp("LIGHT GREY",s)==0) ||
       (strcmp("GRAY",s)==0) || (strcmp("LIGHT GRAY",s)==0) ||
       (strcmp("LIGHTGREY",s)==0) || (strcmp("LIGHTGRAY",s)==0) ||
       (strcmp("7",s)==0))
      return(7);
   if ((strcmp("DARK GREY",s)==0) || (strcmp("DARK GRAY",s)==0) ||
       (strcmp("DARKGREY",s)==0) || (strcmp("DARKGRAY",s)==0) ||
       (strcmp("8",s)==0))
      return(8);
   if ((strcmp("LIGHTBLUE",s)==0) || (strcmp("LIGHT BLUE",s)==0) ||
       (strcmp("9",s)==0))
      return(9);
   if ((strcmp("LIGHTGREEN",s)==0) || (strcmp("LIGHT GREEN",s)==0) ||
       (strcmp("10",s)==0))
      return(10);
   if ((strcmp("LIGHTCYAN",s)==0) || (strcmp("LIGHT CYAN",s)==0) ||
       (strcmp("11",s)==0))
      return(11);
   if ((strcmp("LIGHTRED",s)==0) || (strcmp("LIGHT RED",s)==0) ||
       (strcmp("12",s)==0))
      return(12);
   if ((strcmp("LIGHTMAGENTA",s)==0) || (strcpy("LIGHT MAGENTA",s)==0) ||
       (strcmp("13",s)==0))
      return(13);
   if ((strcmp("YELLOW",s)==0) || (strcmp("14",s)==0))
      return(14);
   if ((strcmp("WHITE",s)==0) || (strcmp("15",s)==0))
      return(15);
   return(-1);
};

void getcolors(short *b, short *c, short *f, short *x, short *t)
{
   FILE *fle;
   char s[256];

   *b = 2;    /* Green */
   *c = 15;   /* White */
   *f = 1;    /* Blue */
   *x = 14;   /* Yellow */
   *t = 4;    /* Red */

   fle = fopen("gredit.cnf","r");
   if (fle)
      {
      while(fgets(s,256,fle))
         {
         massage(s);
         if (*s && (*s != '#'))
            {
            short wh, col;
            char *t = s;
            wh = idwhich(&t);
            col = idcolor(t);
            if ((wh == ' ') || (col == -1))
               {
               printf("Error in configuration file:\n%s\n",s);
               getch();
               };
            switch(wh)
               {
               case 'B':  *b = col; break;
               case 'C':  *c = col; break;
               case 'F':  *f = col; break;
               case 'X':  *x = col; break;
               case 'T':  *t = col; break;
               };
            };
         };
      fclose(fle);
      };
};

void drawstr(const char *s, short color, short x, short y)
{
   while(*s)
      {
      drawchr(*s,color,x,y);
      s++;
      x+=8;
      };
};

void drawcursor(short x, short y, short color)
{
   _setcolor(color);
   _moveto(120+20*x, 80+20*y);
   _lineto(120+20*x,100+20*y);
   _lineto(140+20*x,100+20*y);
   _lineto(140+20*x, 80+20*y);
   _lineto(120+20*x, 80+20*y);
};

void drawgridsq(short x, short y, short fill, short colorb, short colorf)
{
   short i;

   drawcursor(x,y,colorb);
   _setcolor(fill ? colorf : 0);
   for(i=1;i<20;i++)
      {
      _moveto(121+20*x,80+20*y+i);
      _lineto(139+20*x,80+20*y+i);
      };
};

void drawgrid(short ch, short colorb, short colorf)
{
   short i,j,k;

   for(i=0;i<16;i++)
      {
      k = chars[ch][i];
      for(j=7;j>=0;j--)
         {
         drawgridsq(j,i,k&0x01,colorb,colorf);
         k >>= 1;
         };
      };
};

void movecursor(byte dir, short *x, short *y, short colorb, short colorc)
{
   /* dir --> 1 up, 2 down, 3 left, 4 right */
   drawcursor(*x,*y,colorb);
   switch(dir)
      {
      case DIR_UP:    if (*y)            (*y)--;
                      break;
      case DIR_DOWN:  if (*y != 15)      (*y)++;
                      break;
      case DIR_LEFT:  if ((*x) || (!*y)) (*x)--;
                      break;
      case DIR_RIGHT: if (*x != 15)      (*x)++;
                      break;
      };
   drawcursor(*x,*y,colorc);
};

void drawzoom(short ch, short colort, short colorb)
{
   _setcolor(colorb);
   _rectangle(_GBORDER, 28,123,56,175);
   drawchr(ch,colort,30,125);
   drawchr(ch,colort,38,125);
   drawchr(ch,colort,46,125);
   drawchr(ch,colort,30,141);
   drawchr(ch,colort,38,141);
   drawchr(ch,colort,46,141);
   drawchr(ch,colort,30,157);
   drawchr(ch,colort,38,157);
   drawchr(ch,colort,46,157);
};

void drawimage(short ch, short x, short y, short colorc, short colorb,
               short colorf, short colort)
{
   drawgrid(ch,colorb,colorf);
   drawgridsq(0,1,0,colorb,0);
   drawchr(ch,colort,106,84);
   drawzoom(ch,colort,colorb);
   drawcursor(x,y,colorc);
};

void drawbigcursor(short i, short color)
{
   _setcolor(color);
   _moveto(xlate[i].xloc-2,xlate[i].yloc-2);
   _lineto(xlate[i].xloc-2,xlate[i].yloc+8);
   _lineto(xlate[i].xloc+4+8*strlen(code(i)),xlate[i].yloc+8);
   _lineto(xlate[i].xloc+4+8*strlen(code(i)),xlate[i].yloc-2);
   _lineto(xlate[i].xloc-2,xlate[i].yloc-2);
};

void printoptions(short colorx, short ch)
{
   _setcolor(0);
   _rectangle(_GFILLINTERIOR,299,19,640,51);
   _setcolor(colorx);
   _moveto(300,20);
   _outgtext("Editing ");
   _outgtext((char *)code(ch));
   _moveto(300,30);
   _outgtext("Editing commands are:");
   _moveto(300,40);
   _outgtext("     Space toggles square");
   _moveto(300,50);
   _outgtext("     `B' Blanks character");
   _moveto(300,60);
   _outgtext("     `S' Saves characters to file");
   _moveto(300,70);
   _outgtext("     `C' Character Menu");
   _moveto(300,80);
   _outgtext("     `T' Transfer char from another file");
   _moveto(300,90);
   _outgtext("     ESC quits");
};

void selectchar(short *ch, short x, short y, short colorx, short colort,
                short colorc, short colorb, short colorf)
{
   short i;
   char c;

   do {
      _setcolor(0);
      _rectangle(_GFILLINTERIOR,299,99,640,350);
      _setcolor(colorx);
      _moveto(300,100);
      _outgtext("Use up and down arrows to");
      _moveto(300,110);
      _outgtext("choose a character to edit.");
      _moveto(300,120);
      _outgtext("Press Enter to exit.");
      i = *ch;
      do {
         _moveto(xlate[i].xloc,xlate[i].yloc);
         _outgtext((char *)code(i));
         i = xlate[i].next;
         }
      while (i!=*ch);
      do {
         drawbigcursor(i,colorc);
         if (i > 0)
            {
            drawgridsq(-1,0,0,colorb,0);
            drawchr(i,colort,106,84);
            };
         c = getch();
         if (!c)
            c = getch();
         drawbigcursor(i,0);
         switch(c)
            {
            case '8':
            case KEY_UP:   i = xlate[i].prev;
                           break;
            case '2':
            case KEY_DN:   i = xlate[i].next;
                           break;

            case 'S':
            case 's':      savechars();
                           break;

            case 27:       shutdown();
                           break;
            };
         }
      while(c!=13);
      if (abs(i) <= MAXMENU)
         i = -i;
      *ch = i;
      }
   while (i <= MAXMENU);

   _setcolor(0);
   _rectangle(_GFILLINTERIOR, 299, 99, 640, 350);
   _setcolor(colorx);
   drawimage(*ch,x,y,colorc,colorb,colorf,colort);
   printoptions(colorx,*ch);
   putmessage(colorx);
};

void getstring(short x, short y, char *s, short colorx)
{
   char c;

   *s = 0;
   do {
      switch (c = getch())
         {
         case 8:   if (strlen(s)>1)
                      s[strlen(s)-1]=0;
                   break;
         case 27:  *s = 0;
         case 13:  break;
         default:  s[strlen(s)+1]=0;
                   s[strlen(s)]=c;
                   break;
         };
      _setcolor(0);
      _rectangle(_GFILLINTERIOR, x-1, y-1, 640, y+11);
      _setcolor(colorx);
      _moveto(x,y);
      _outgtext(s);
      }
   while(c!=13);
};

void userinterface(short colorc, short colorb, short colorf, short colort,
                   short colorx, short *ch)
{
   short j,x,y;
   char c;
   char fn[256];

   _setcolor(colorx);
   printoptions(colorx,*ch);
   x = -1;
   y = 0;
   do {
      if ((x<0) || (*ch==0))
         {
         selectchar(ch,x,y,colorx,colort,colorc,colorb,colorf);
         if (x<0)
            movecursor(DIR_RIGHT,&x,&y,colorb,colorc);
         drawchr(*ch,colort,106,84);
         };
      c = getch();
      if (!c)
         c = getch();
      c = toupper(c);
      switch(c)
         {
         case '1':
         case KEY_END:    movecursor(DIR_DOWN,&x,&y,colorb,colorc);
                          movecursor(DIR_LEFT,&x,&y,colorb,colorc);
                          break;
         case '2':
         case KEY_DN:     movecursor(DIR_DOWN,&x,&y,colorb,colorc);
                          break;

         case '3':
         case KEY_PGDN:   movecursor(DIR_RIGHT,&x,&y,colorb,colorc);
                          movecursor(DIR_DOWN,&x,&y,colorb,colorc);
                          break;

         case '4':
         case KEY_LEFT:   movecursor(DIR_LEFT,&x,&y,colorb,colorc);
                          break;

         case '6':
         case KEY_RIGHT:  movecursor(DIR_RIGHT,&x,&y,colorb,colorc);
                          break;
 
         case '7':
         case KEY_HOME:   movecursor(DIR_UP,&x,&y,colorb,colorc);
                          movecursor(DIR_LEFT,&x,&y,colorb,colorc);
                          break;

         case '8':
         case KEY_UP:     movecursor(DIR_UP,&x,&y,colorb,colorc);
                          break;

         case '9':
         case KEY_PGUP:   movecursor(DIR_UP,&x,&y,colorb,colorc);
                          movecursor(DIR_RIGHT,&x,&y,colorb,colorc);
                          break;

         case 27:         break;
         case 'S':        savechars();
                          break;
         case ' ':        chars[*ch][y] ^= (0x80 >> x);
                          drawgridsq(x,y,chars[*ch][y] & (0x80 >> x),colorb,colorf);
                          drawchr(*ch,colort,106,84);
                          drawzoom(*ch,colort,colorb);
                          drawcursor(x,y,colorc);
                          break;

         case 'B':        for(j=0;j<16;j++)
                             chars[*ch][j]=0;
                          drawimage(*ch,x,y,colorc,colorb,colorf,colort);
                          drawchr(*ch,colort,106,84);
                          drawzoom(*ch,colort,colorb);
                          drawcursor(x,y,colorc);
                          break;
         case 'C':        selectchar(ch,x,y,colorx,colort,colorc,colorb,colorf);
                          break;
         case 'T':        _setcolor(colorx);
                          _moveto(300,120);
                          _outgtext("File to import: ");
                          _moveto(300,130);
                          _outgtext("-->");
                          getstring(332,130,fn,colorx);
                          prepend("lib\\xtra\\",fn);
                          if (fexist(fn))
                             {
                             importchar(*ch,fn);
                             drawimage(*ch,x,y,colorc,colorb,colorf,colort);
                             drawchr(*ch,colort,106,84);
                             drawzoom(*ch,colort,colorb);
                             drawcursor(x,y,colorc);
                             _setcolor(colorx);
                             _moveto(300,150);
                             _outgtext("Character imported.");
                             }
                          else
                             {
                             _setcolor(colorx);
                             _moveto(300,150);
                             _outgtext("File not found.");
                             };
                          delay(2000);
                          _setcolor(0);
                          _rectangle(_GFILLINTERIOR,299,119,640,480);
                          break;
         };
      }
   while (c!=27);
};

void help(void)
{
   printf("GrEdit - Bitmap graphic editor\n"
          "usage:   gredit [graphics.fnt]\n\n"
          "If ommited, the file defaults to angband.fnt.\n"
          "The file will always be search for in the lib/xtra directory.\n\n");
   logo();
   exit(0);
};

void main(int argc, char **argv)
{
   short colorb, colorc, colorf, colorx, colort;
   short ch;

   if (argc==2)
      {
      strcpy(filename,"lib\\xtra\\");
      strcat(filename,argv[1]);
      }
   else if (argc>2)
      help();
   else
      strcpy(filename,"lib\\xtra\\angband.fnt");

   if (!fexist(filename))
      {
      printf("File %s not found.\n",filename);
      help();
      };

   ch = -1;

   _clearscreen( _GCLEARSCREEN );
   getchars();
   getcolors(&colorb,&colorc,&colorf,&colorx,&colort);
   initgraphics(colorx);
   userinterface(colorc,colorb,colorf,colort,colorx,&ch);
};
