/* File: borg4.h */

/* Purpose: Header file for "borg4.c" -BEN- */

#ifndef INCLUDED_BORG4_H
#define INCLUDED_BORG4_H

#include "angband.h"

#ifdef ALLOW_BORG

/*
 * This file provides support for "borg4.c".
 */

#include "borg1.h"
#include "borg2.h"
#include "borg3.h"



/*
 * Extract various bonuses
 */
extern void borg_notice(void);

/*
 * Extract various bonuses from the home
 */
extern void borg_notice_home(void);


/*
 * Calculate the basic "power"
 */
extern s32b borg_power(void);

/*
 * Calculate the basic "power" of the home
 */
extern s32b borg_power_home(void);



/*
 * Calculate danger to a grid from a monster
 */
extern int borg_danger_aux(int y, int x, int c, int i);

/*
 * Hack -- Calculate the "danger" of the given grid.
 */
extern int borg_danger(int y, int x, int c);


/*
 * Determine if the Borg is out of "crucial" supplies.
 */
extern bool borg_restock(void);

/*
 * Determine if the Borg is "prepared" for the given level
 */
extern bool borg_prepared(int depth);


/*
 * Initialize this file
 */
extern void borg_init_4(void);


#endif

#endif

