#       your favorite compiler
CC      =       tcc

#       user id of wizard       (wizard password is defined in config.c)
WIZID   =       0

#       name of program
GAME    =       Ularn.exe

#       program options
OPTIONS =       -DWIZID=$(WIZID)

#       compile flags
CFLAGS = -v -mh $(OPTIONS)

#       link flags
LDFLAGS = /v

#       the object files
OBJ     = bill.obj config.obj create.obj data.obj diag.obj display.obj \
        fortune.obj global.obj help.obj io.obj main.obj monster.obj \
        moreobj.obj movem.obj object.obj regen.obj savelev.obj scores.obj \
        signal.obj store.obj tok.obj nap.obj

#       the source files
SRC     = bill.c config.c create.c data.c diag.c display.c fortune.c\
        global.c help.c io.c main.c monster.c moreobj.c movem.c object.c\
        regen.c savelev.c scores.c signal.c store.c tok.c nap.c

#       the header file
HDR     = header.h

UTIL = to_ansi.exe
UTIL_OBJ = to_ansi.obj
UTIL_SRC = to_ansi.c

##########################################################################

hate:   $(GAME) Uhelp

$(GAME): $(OBJ)
        tlink $(LDFLAGS) @ularn.lnk

.c.obj:
        $(CC) -c $(CFLAGS) $.

$(OBJ): header.h

$(UTIL): $(UTIL_SRC)
        tcc $(UTIL_SRC)

#$(UTIL): $(UTIL_OBJ)
#       $(CC) $(UTIL_OBJ)

Uhelp: $(UTIL) Uhelp.no_control
        makehelp

love: love
	@echo Requires a hardware upgrade

