#! /bin/perl -w
#
# give a user a new password and create credentials
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $U;
my $UID;
my $P; 
$U = shift @ARGV;
$UID = shift @ARGV;
$P = shift @ARGV;
my $name = Nisplus::get_first($U);

if (!defined($U) || !defined($UID) || !defined($P)){ usage();}

my $domain = Nisplus::strip_first($U);
$domain =~ /(.*)\./;
my $des_domain = $1;

if ($UID ne '0') {
	print `nisaddcred -p $UID -P $U local $domain`;
	print `nisaddcred -l $P -p unix.$UID\@$des_domain -P $U des $domain`;
	my @chars = ('a'..'z', 'A'..'Z');
	srand(time|$$);
	my $salt = $chars[int(rand($#chars))];
	srand(time + 1);
	$salt .= $chars[int(rand($#chars))];
	my $crypt_string = crypt($P, $salt);
	my $arg = "-m  passwd=$crypt_string '[name=$name,uid=$UID]'passwd.org_dir.$domain";
	print `nistbladm $arg`;
}
else {
	print `nisaddcred -l $P -p unix.$name\@$des_domain -P $U des $domain`;
}
print `nisping org_dir.$domain`;
exit 0;



sub usage {
	print STDERR "usage: $0 user uid password\n";
	exit 1;
}
