#! /bin/perl -w
#
# load a NIS+ Table from a file
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $T;
my $F; 
my $RETSTR;
my $append=0;
my $merge=0;
my $replace=0;
my $opt="";

## Tables that can be loaded with nisaddent
my $STANDARD = "aliases bootparams ethers group hosts netgroup netid netmasks networks passwd protocols rpc services shadow timezone";


if ($#ARGV < 1 || $#ARGV > 2 ) {usage();}
if ($ARGV[0] =~ /^-.*/) {
	$_ = shift @ARGV;
	$replace=1 if /r/;
	$append=1 if /a/;
	$merge=1 if /m/;
}
if($replace){$opt='-r';}
if($append){$opt='-a';}
if($merge){$opt='-m';}
$T = shift @ARGV;
$F = shift @ARGV;

if (!($T =~ /.*\.$/)) {
	$!=1;
	die "Error: Tablename must be fully qualified.\n";
}
if (-e $F && !(-f $F)){ 
	$!=1;
	die "Error: $F exists but is not a File.\n";
}
my $name = Nisplus::get_first($T);
if ($name eq 'shadow'){
	$name = 'passwd.' . Nisplus::strip_first($T);
} else { $name = $T;}
my $o = Nisplus->new($name);
$o->getattr();
if ($RETSTR = $o->get_error()){
	$!=1;
	die "Error: $RETSTR\n";
}


loadtable();
my $domain = Nisplus::strip_first($T);
print `nisping $domain`;
exit 0;


##
## load a table for file
##
sub loadtable {
	my @out;

	if (is_standard_table($T)){
		load_standard_table();
	}
	else {
		load_non_standard_table();
	}
}


##
## load a standard table from a file
##
sub load_standard_table{
	my $RETSTR;
	my $TN = Nisplus::get_first($T);
	my $domain = Nisplus::strip_first($T);
	if (Nisplus::get_first($domain) ne 'org_dir'){
		$!=1;
		die "Error: $T is not a standard table in org_dir.$domain\n";
	}
	$domain = Nisplus::strip_first($domain);
	if ($F =~ /.*\/shadow/) { $TN = 'shadow';}
	if ($TN eq 'shadow') { $opt = ''; }
	print `nisaddent $opt -f $F $TN $domain`;
}

##
## load an arbitary table
##
sub load_non_standard_table{
	my $RETSTR;
	my @line;
	my $i;
	my $o = Nisplus->new($T);
	$o->getattr();
	if ($RETSTR = $o->get_error()){
		$!=1;
		die "Error: $RETSTR\n";
	}
	my $SEP = $o->{'Sep'};
	$SEP = '\s+' if $SEP eq ' ';
	open (FILE, $F) || die "Error: Can't open $F: $!";
	while (<FILE>){
		my $command = 'nistbladm -a ';
		@line = split(/$SEP/, $_, $o->{'Colnum'});
		if ($line[0] =~ /\s*#.*/) { next ;}
		for($i=0; $i<$o->{'Colnum'}; $i++){
			my $colname = $o->{"Col$i"}->{'Name'};
			if (defined($line[$i])) {
				chop ($line[$i]) if ($line[$i]=~/.*\n/);
				$command .= "$colname=\'$line[$i]\' ";
			}
		}
		$command .= "$T";
	print `$command`; 
	}
	close (FILE);
}


##
## is it a standard table?
##
sub is_standard_table{
	my $T = shift;
	my $NAME = Nisplus::get_first($T);
	if ($NAME eq 'cred') { $NAME = 'publickey'};
	if ($STANDARD =~ /$NAME/){
		return 1;
	}
	return 0;
}

##
## find an error in th eoutput string
##
sub find_error {
	my $RET;
	foreach (@_){
		if (/Error/ || /error/ || /cannot/ || /can't/) { 
			if (defined($RET)) {$RET .= $_ ; }
			else { $RET=$_;}
		}
	}
	return $RET;
}


sub usage {
	print STDERR "usage: $0 [-cma] table sourcefile\n";
	exit 1;
}
