#include <stdio.h>
#include <midi.h>

static	int	Period = MPU_CLOCK_PERIOD;
static	long	last = 0;
static	long	nexttcwme = 2*MPU_CLOCK_PERIOD;

MidiClockPut(out, mp, when)
FILE	*out;
MpuCmd	*mp;
long	when;
/*
** Write MIDI commands on 'out', adding TCIP & TCWME commands.
** Ignore the times specified in the MpuCmd entry, just use "when".
** Also ignore TCIP & TCMWE commands.
** The calls to MidiClockPut must occur in chronological order.
** Example: 'MidiClockPut(out, &m, t)' writes out the event in m
** (assuming it's not a TCIP or TCWME command) such that it will be
** played at time t, inserting any Timing Clock In Progress or Timing
** Clock With Measure End commands as necessary.
** NOTE: a call with mp = 0 will pad timing commands out to the specified
** time and reinitialize the static data for another run.
** Example: 'MidiClockPut(out, (MpuCmd *) 0, t)'
** FURTHER: a call with mp = 0 and when = 0 will pad timing commands out
** to the next measure end and reinitialize the static data for another run.
** Example: 'MidiClockPut(out, (MpuCmd *) 0, 0L)'
*/
{
	int put, dur;
	long next;

	if (mp == (MpuCmd *) 0) {
	    if (when == 0 && last > nexttcwme - 2 * Period)
		when = nexttcwme;
	} else if (mp->time_tag == RT_TCIP || mp->mpu_cmd[0] == RT_TCWME)
	    return;
	do {
	    next = nexttcwme < when? nexttcwme : when;
	    while (next - last >= Period)
		PutTCIP(out), last += Period;
	    if (next == nexttcwme) {
		PutTCWME(out, next - last);
		last = nexttcwme;
		nexttcwme = last + 2 * Period;
	    }
	} while (next < when);
	if (mp == (MpuCmd *) 0) {
	    if (when != last)
		PutTCWME(out, when - last);
	    last = 0;
	    nexttcwme = last + 2 * Period;
	} else {
	    mp->time_tag = (unsigned char) next - last;
	    mp->mpu_time = (long) next - last;
	    PutMpuCmd(out, mp);
	    last = next;
	}
}
