#include "conf.h"
#include <sys/time.h>
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include "readline.h"
#include "nntplink.h"

Bfile_struct Batchfile = {
    NULL,
    NULL,
    NULL,
    0L,
    0,
    NULL,
    BATCH_SLEEP,
    TRUE,
    FALSE,
};

Lfile_struct Logfile = {
    LOGFILE,
    0L,
    0,
    NULL,
    LOGFILE_SLEEP,
};

Host_struct Host = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    T_IP_TCP,
    FALSE,
};

Art_struct Article = {
    NULL,
    NULL,
    NULL,
    0,
    NULL,
};

Stats_struct Stats = {
    0L,
    0L,
    0L,
    0L,
    0L,
    0L,
};

Time_struct Time = {
    0L,
    0.,
    0.,
    0L,
    0L,
    0.,
    0.,
};

FileBuf *Stdin = NULL;		/* fbp used by readline() */

char *Prog_name;
int Prog_pid;

int Close_after = CLOSE_AFTER;
int Log_after = LOG_AFTER;
int Dtablesize;


Boolean Log_close = FALSE;

Boolean Open_art_first = FALSE;

long Success_time, Report_time = 0L;

long Failure_naptime = NAPTIME;

long Fail_minutes = FAIL_MINUTES;
long Repeat_minutes = REPEAT_MINUTES;

long Close_timeout = CLOSE_TIMEOUT;
long Exit_timeout = EXIT_TIMEOUT;
long Entry_sleep = ENTRY_SLEEP;

long Idle_time = 0L;

char *E_chdir = "%s%s: chdir(%s): %s\n";
char *E_fcntl = "%s%s: fcntl(%s, %s): %s\n";
char *E_fdopen = "%s%s: fdopen(%d, \"%s\"): %s\n";
char *E_fopen = "%s%s: fopen(%s, \"%s\"): %s\n";
char *E_fstat = "%s%s: fstat(%s): %s\n";
char *E_fseek = "%s%s: fseek(%s): %s\n";
char *E_open = "%s%s: open(%s, \"%s\"): %s\n";
char *E_read = "%s%s: error reading: %s\n";
char *E_rename = "%s%s: rename(%s, %s): %s\n";
char *E_unlink = "%s%s: unlink(%s): %s\n";
char *E_write = "%s%s: error writing: %s\n";

extern Boolean Debug;
extern int Input_from;

extern void check_batchfile();
extern void check_sleep();
extern void log();
extern void parse_args();
extern Boolean send_news();
extern void setup_proc();
extern void update_batchfile();

main(argc, argv)
     int argc;
     char *argv[];
{
    int fd;
    static char *fname = "main: ";
    long current_time;
    long fail, repeat;

#ifdef DEBUG_MAL
    mal_debug(3);
#endif

#ifdef DTABLESIZE
    Dtablesize = DTABLESIZE;
#else
    Dtablesize = getdtablesize();
#endif

    for (fd = Dtablesize - 1; fd > 2; fd--)
      (void) close(fd);

    parse_args(argc, argv);

    setup_proc();

    for (;;) {

	if (Batchfile.use && (Batchfile.fbp == NULL))
	  check_batchfile();

	if (!send_news()) {

	    current_time = time(NULL);

	    fail = (current_time - Success_time) / 60;
	    repeat = (current_time - Report_time) / 60;

	    if ((fail >= Fail_minutes) &&
		(repeat >= Repeat_minutes)) {

		log(LOG_WARNING, fname, "%s%s: Link down for %ld hours\n",
		    Host.name, (long)(fail / 60));
		Report_time = time(NULL);
	    }

	    if ((fail >= SPOOL_MINUTES) &&
		(Input_from & FLG_LOGFILE))
	      update_batchfile();

	    dlog(LOG_DEBUG, fname,
		 "%ssend_news() returned error - sleeping for %d seconds\n",
		 Failure_naptime);

	    check_sleep(Failure_naptime, CREATE_BATCH);

	    if ((Failure_naptime *= 2)> MAX_NAPTIME)
	      Failure_naptime = MAX_NAPTIME;
	}
    }
}
