/* ZGV v2.0 - (c) 1993,1994 Russell Marks for improbabledesigns.
 * See README for license details.
 *
 * zgv.c - This provides the zgv file selector, and interfaces to the
 *         vga display routines (vgadisp.c)
 */

#define ZGV_VER		"2.0"


#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <setjmp.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <vga.h>

#include "gifeng.h"
#include "vgadisp.h"
#include "readnbkey.h"
#include "font.h"
#include "3deffects.h"
#include "handlevt.h"
#include "helppage.h"
#include "rc_config.h"
#include "rcfile.h"
#include "usejpeg.h"  /* we only use *this* for my_error_exit() */

#include "zgvlogopck.h"



char zgvhelp[][80]={
  " \0", " \0",
  "Question mark \t this help page\0",
  " \0",
  "up (also k or q) \t move file selection cursor up\0",
  "down (also j or a) \t move file selection cursor down\0",
  "left (also h or o) \t move file selection cursor left\0",
  "right (also l or p) \t move file selection cursor right\0",
  " \0",
  "Enter \t\t display file or change directory\0",
  " \0",
#ifdef HANDS_ON_VC_CODE
  "F1 to F8 \t\t change virtual console\0",
  " \0",
#endif
  "Esc or x \t\t exit zgv\0",
  "\0"
  };


#define fwinxpos(f) (40+(((f)-1)/YSIZ)*BARWIDTH)
#define fwinypos(f) (200+BARHEIGHT*(((f)-1)%YSIZ))


#define LIGHT 2
#define DARK 1
#define BLACK 15
#define MIDGREY 0

#define GDFSIZ 3
#define BARWIDTH 130
#define BAR_RESTRICT_WIDTH  BARWIDTH-6
#define BARHEIGHT (GDFSIZ*6+6)

#define COLS 589
#define MDIRSIZ 1000
#define YSIZ (250/BARHEIGHT)


int gcompare(void *,void *);
void showhowfar(int,int);
void exitproperly();

struct GDIR {
  char name[256];
  char isdir;            /* 0=file, 1=dir. */
  } gifdir[MDIRSIZ];
int gifdirsiz;

int zgv_ttyfd,howfar_upto;
jmp_buf setjmpbuf;   /* in case someone aborts decompressing a file */


main(argc,argv)
int argc;
char **argv;
{
if((argc!=1)&&(argc!=2))
  usage();

pixelsize=1;
getconfig();
copyfromconfig();
vga_disabledriverreport();    /* first we tame svgalib... */
	/* vga_disable... doesn't seem to work any more! */
vga_init();
/* root permissions should now have been ditched */
cleartext();

/* do one-file-only if have arg. */
if(argc==2)
  {
  fprintf(stderr,"Loading...");
  if(readgiforjpg(argv[1],NULL)!=0)
    {
    fprintf(stderr,"\rError loading file.\n");
    exit(1);
    }
  screenoff();
  exit(0);
  }

screenon();
if((zgv_ttyfd=open("/dev/tty0",O_RDONLY|O_NONBLOCK))>=0)
  {
  mainloop();
  close(zgv_ttyfd);
  }
screenoff();
exit(0);
}


usage()
{
printf("Zgv v%s - (c) 1993,1994 Russell Marks for improbabledesigns.",ZGV_VER);
printf("\n\nUsage: zgv [filename]\n\n");
exit(1);
}


copyfromconfig()
{
curvgamode=cfg.videomode;
zoom=cfg.zoom;
vkludge=cfg.vkludge;
brightness=cfg.brightness;
contrast=cfg.contrast;
if((curvgamode==G320x400x256)||(curvgamode==G360x480x256))
  virtual=1;
else
  virtual=0;
}


mainloop()
{
int quit,key,curent; /* quit, key pressed, current entry */
int oldent,startfrom,oldstart,f,tmp;
char cline[100],buf[1024];

quit=0; curent=1; oldent=1;
startfrom=1;

readgifdir();
showgifdir(startfrom,0);
showbar(curent,1,startfrom);
while(!quit)
  {
  oldent=curent;
  usleep(10000);
  key=readnbkey(zgv_ttyfd);

/* for consistency between zgv.c and vgadisp.c, we don't use the old VC
 * switching code unless...
 */
#ifdef HANDS_ON_VC_CODE
  /* if it's from F1 to F8, we switch consoles */
  if((key>=RK_F1)&&(key<=RK_F8))
    if(handlevt(zgv_ttyfd,key-RK_F1+1))
      redrawall(curent,startfrom);
#endif
  
  switch(key)
    {
    case 'c':
      if(pixelsize==1) pixelsize=3; else pixelsize=1;
      break;
    case '?':
      showhelp(zgv_ttyfd,"- KEYS FOR FILE SELECT SCREEN -",zgvhelp);
      redrawall(curent,startfrom);
      break;
    case 18: case 12:   /* ^R and ^L */
      readgifdir();
      redrawall(curent,startfrom);
      break;
    case 'q': case 'k': case RK_CURSOR_UP:
      if(curent>1) curent--; break;
    case 'a': case 'j': case RK_CURSOR_DOWN:
      if(curent<gifdirsiz) curent++; break;
    case 'o': case 'h': case RK_CURSOR_LEFT:
      curent-=YSIZ;
      if(curent<1) curent=1;
      break;
    case 'p': case 'l': case RK_CURSOR_RIGHT:
      curent+=YSIZ;
      if(curent>gifdirsiz) curent=gifdirsiz;
      break;
    case RK_ENTER:
      if(permissiondenied(gifdir[curent].name))
        {
        msgbox(zgv_ttyfd,"Permission denied or file not found",
        	MSGBOXTYPE_OK,LIGHT,DARK,BLACK);
        redrawall(curent,startfrom);
        break;
        }
      if(gifdir[curent].isdir)
        {
        showbar(curent,0,startfrom);
        showgifdir(startfrom,1);
        chdir(gifdir[curent].name);
        readgifdir();
        showgifdir(1,0); curent=oldent=startfrom=1;
        showbar(curent,1,startfrom);
        }
      else
        {
        inithowfar();
        /* save context for possible abort */
        if(setjmp(setjmpbuf))
          /* if we get here, someone aborted loading a file. */
          msgbox(zgv_ttyfd,"File view aborted",MSGBOXTYPE_OK,LIGHT,DARK,BLACK);
        else
          {
          if((tmp=readgiforjpg(gifdir[curent].name,showhowfar))!=0)
            showerrmessage(tmp);
          }
        redrawall(curent,startfrom);
        }
      break;
    case 26:   /* ^Z */
      screenoff();
      raise(SIGTSTP);
      redrawall(curent,startfrom);
      break;
    case 'x': case RK_ESC:
      quit=1;
    }
    
  oldstart=startfrom;
  while(curent<startfrom)
    startfrom-=YSIZ;
  while(fwinxpos(curent-startfrom+1)+BARWIDTH>COLS)
    startfrom+=YSIZ;
  if(startfrom!=oldstart)
    {
    showbar(oldent,0,oldstart);
    showgifdir(oldstart,1);
    showgifdir(startfrom,0);
    showbar(curent,1,startfrom);
    }
  else  
    if(curent!=oldent)
      {
      showbar(oldent,0,startfrom);
      showbar(curent,1,startfrom);
      }
  }
}


/* this could also be file not found of course */
int permissiondenied(fname)
char *fname;
{
FILE *junk;
if((junk=fopen(fname,"rb"))==NULL)
  return(1);
fclose(junk);
return(0);
}


redrawall(curent,startfrom)
int curent,startfrom;
{
screenon();
showgifdir(startfrom,0);
showbar(curent,1,startfrom);
}

inithowfar()
{
int f;

vga_setcolor(0);
for(f=220;f<=260;f++)
  vga_drawline(100,f,540,f);
draw3dbox(100,220,540,260,2,1, LIGHT,DARK);
draw3dbox(109,229,531,251,1,0, LIGHT,DARK);

howfar_upto=0;
drawtext3d(250,235,2,"Decompressing - please wait",0, LIGHT,DARK,BLACK);
vga_setcolor(2);
}

void showhowfar(sofar,total)
int sofar,total;
{
int f,d;

/* we jump back to an abort message if Esc was pressed */
if(readnbkey(zgv_ttyfd)==RK_ESC)
  {
  /* these routines blast the malloc'ed stuff, which has *for sure*
   * been allocated by now, because we must already be reading the file
   * in for us to get here!
   */
  if(is_this_file_jpeg())
    aborted_file_jpeg_cleanup();
  else
    aborted_file_gif_cleanup();
  longjmp(setjmpbuf,1);
  }
if(((sofar%10)==0)||(sofar==total))
  {
  vga_setcolor(2); /* we set this always in case of a VC switch */
  d=(420*sofar)/total;
  if(d>howfar_upto)
    {
    for(f=howfar_upto;f<=d;f++)
      vga_drawline(110+f,230,110+f,250);
    howfar_upto=f;
    }
  }
}

showbar(entnum,selected,startfrom)
int entnum,selected;
int startfrom;
{
char ctmp[100];
int xpos,ypos;

xpos=fwinxpos(entnum-startfrom+1);
if((xpos<1)||(xpos+BARWIDTH>COLS)) return(0);
ypos=fwinypos(entnum-startfrom+1);
prettyfile(&ctmp,&(gifdir[entnum]));

set_max_text_width(BAR_RESTRICT_WIDTH);
if(selected)
  {
  draw3dbox(xpos,ypos,xpos+BARWIDTH-1,ypos+BARHEIGHT-1,1,1, LIGHT,DARK);
  drawtext3d(xpos+3,ypos+3,GDFSIZ,ctmp,0, LIGHT,DARK,BLACK);
  }
else
  {
  undraw3dbox(xpos,ypos,xpos+BARWIDTH-1,ypos+BARHEIGHT-1,1);
  undrawtext3d(xpos+3,ypos+3,GDFSIZ,ctmp);
  vga_setcolor(15);
  vgadrawtext(xpos+3,ypos+3,GDFSIZ,ctmp);
  }
set_max_text_width(NO_CLIP_FONT);
}


showgifdir(startfrom,unshow)
int startfrom,unshow;
{
char cdir[MAXPATHLEN+1];
char ctmp[MAXPATHLEN+100];
int f,ypos,xpos;

getcwd(cdir,MAXPATHLEN);
sprintf(ctmp,"Directory of %s",cdir);
if(unshow)
  undrawtext3d(40,140,4,ctmp);
else
  drawtext3d(40,140,4,ctmp,1, LIGHT,DARK,BLACK);

set_max_text_width(BAR_RESTRICT_WIDTH);
vga_setcolor(unshow?0:15);
for(f=startfrom;f<=gifdirsiz;f++)
  {
  xpos=fwinxpos(f-startfrom+1);
  if(xpos+BARWIDTH>COLS) break;

  ypos=fwinypos(f-startfrom+1);
  prettyfile(&ctmp,&(gifdir[f]));
  vgadrawtext(xpos+3,ypos+3,GDFSIZ,ctmp);
  }
set_max_text_width(NO_CLIP_FONT);
}

readgifdir()
{
DIR *dirfile;
struct dirent *anentry;
struct stat buf;
char cdir[MAXPATHLEN+1];
int entnum,l,isdir;

getcwd(cdir,MAXPATHLEN);
dirfile=opendir(".");
entnum=0;
while((anentry=readdir(dirfile))!=NULL)
  {
  if((strcmp(anentry->d_name,".")!=0)&&       /* no . and no .. if at root */
     (!((strcmp(cdir,"/")==0)&&(strcmp(anentry->d_name,"..")==0))))
    {
    if((stat(anentry->d_name,&buf))==-1)
      buf.st_mode=0;
    if((buf.st_mode&0x7000)==0x4000) isdir=1; else isdir=0;
    if(((l=strlen(anentry->d_name))>4)||(isdir))     /* directories, GIFs, */
      if((!strncmp(anentry->d_name+l-4,".gif",4))||     /* JPEGs only */
         (!strncmp(anentry->d_name+l-4,".jpg",4))||(isdir))
        {
        entnum++;
        gifdir[entnum].isdir=isdir;
        strcpy(gifdir[entnum].name,anentry->d_name);
        }
    }
  }
closedir(dirfile);
gifdirsiz=entnum;
qsort(&(gifdir[1]),gifdirsiz,sizeof(struct GDIR),(void *)gcompare);
}


int gcompare(gn1,gn2)
void *gn1,*gn2;
{
struct GDIR *g1,*g2;
char buf1[80],buf2[80];

g1=(struct GDIR *)gn1; g2=(struct GDIR *)gn2;
prettyfile(buf1,g1); prettyfile(buf2,g2);
return(strcmp(buf1,buf2));
}


prettyfile(buf,gifdptr)
char *buf;
struct GDIR *gifdptr;
{
if(gifdptr->isdir)
  {
  buf[0]='(';
  strcpy(buf+1,gifdptr->name);
  strcat(buf,")");
  }
else
  strcpy(buf,gifdptr->name);
}


screenon()
{
vga_setmode(G640x480x16);
vga_setflipchar('#');
vga_setcolor(15);
vga_setpalette(MIDGREY,cfg.medium_r,cfg.medium_g,cfg.medium_b);
vga_setpalette(DARK,cfg.dark_r,cfg.dark_g,cfg.dark_b);
vga_setpalette(LIGHT,cfg.light_r,cfg.light_g,cfg.light_b);

vga_setpalette(BLACK,cfg.black_r,cfg.black_g,cfg.black_b);

draw3dbox(0,0,639,99,2,1, LIGHT,DARK);
draw3dbox(10,10,629,89,1,0, LIGHT,DARK);

draw3dbox(0,100,639,479,2,1, LIGHT,DARK);
draw3dbox(10,110,629,469,1,0, LIGHT,DARK);

drawzgvlogo(10,10);
}


screenoff()
{
vga_setmode(TEXT);
cleartext();
}


drawzgvlogo(a,b)
int a,b;
{
int x,y,c,bw;
byte *ptr;

ptr=zgvlogo;
bw=logow>>3;
if((logow%8)>0) bw+=1;
vga_setcolor(BLACK);
for(y=0;y<logoh;y++)
  {
  ptr=zgvlogo+y*bw;
  for(x=0;x<logow;x++)
    {
    if((x%8)==0)
      c=*ptr;
    if((c&128)==0) vga_drawpixel(a+x,b+y);
    c<<=1;
    c&=0xff;
    if((x%8)==7)
      ptr++;
    }
  }
}


cleartext()
{
fprintf(stderr,"\x1b[H\x1b[J");
}


/* this shows any error message from GIF reading.
 * Notice that JPEG errors have already been reported!
 */
showerrmessage(errnumber)
int errnumber;
{
char buf[256];

strcpy(buf,"Error reading file - ");
switch(errnumber)
  {
  case _GIFERR_NOFILE:
    strcat(buf,"file not found"); break;
  case _GIFERR_NOMEM:
    strcat(buf,"out of memory"); break;
  case _GIFERR_NOTGIFFILE:
    strcat(buf,"not a GIF file"); break;
  case _GIFERR_NOCOLOURMAP:
    strcat(buf,"no global colour map"); break;
  case _GIFERR_NOIMAGE:
    strcat(buf,"no image block found"); break;
  case _GIFERR_LOCALMAP:
    strcat(buf,"can't handle local colour maps"); break;
  case _GIFERR_CORRUPT:
    strcat(buf,"corrupt or short file"); break;
  case _GIFERR_SHOWN_ALREADY:
    /* this only happens with JPEGs, actually! */
    return;
  default:
    strcat(buf,"unknown error (ulp!)");
  }
msgbox(zgv_ttyfd,buf,MSGBOXTYPE_OK, LIGHT,DARK,BLACK);
}
