%{

/*  VT1500 Device Driver for Linux, Version 1.0.5
 *  Copyright (C) 1995  M. Gutschke
 *
 *  At the time of writing my e-mail address is:
 *	Internet: gutschk@uni-muenster.de
 *  My snail mail address is:
 *	Markus Gutschke
 *	Schlage 5a
 *	48268 Greven-Gimbte
 *	Germany
 *  If you like this software, I would appreciate if you sent me a postcard
 *  from your hometown. Under the terms of the GNU general public license
 *  you are free to include this program into (commercial) software
 *  distributions (e.g. putting it onto CD-ROM); nonetheless, I would really
 *  appreciate if you dropped me a short note (sending me a sample copy of
 *  your distribution would be even more appreciated!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>

#include "rc.h"
#include "tvcontrol.h"

static char shortName[4],longName[21];
static int  frq,adj;

extern char *rctext;
extern int  rcReadOnly;

static inline int min(int a,int b) {return(a < b ? a : b);}
static inline int max(int a,int b) {return(a > b ? a : b);}

static int fromPercentage(int val,int def,int maxval)
{
  if (val < 0)
    return(min(maxval,max(0,(val*def-50)/100+def)));
  else if (val == 0)
    return(def);
  else
    return(min(maxval,max(0,(val*(maxval-def)+50)/100+def)));
}

%}

%token NUMBER FNUMBER NAME STRING
%token READONLY EXTERNALMUTE PORT STATION MHZ RADIO PAL NTSC DISPLAY VGA
%token TUNER SOURCE TV VCR CHANNEL MODE MUTE ON OFF BASS TREBLE VOLUME
%token BRIGHTNESS SATURATION CONTRAST HUE RED GREEN BLUE

%%

rc:	
	|	rc directive

directive: 	station
	|  	preference

station: 	STATION NUMBER ':' frequency MHZ shortname mode longname
					{ int index;
                                          if (adj < -99 || adj > 99 ||
                                              strcasecmp(shortName,
                                                         channelName(frq,
                                                                     &index)))
                                            rcerror("Invalid frequency");
                                          if ($2 < 0 || $2 >= 100)
                                            rcerror("Invalid station number");
                                          setChannelInfo(index,longName,adj,
                                                         $2,$7); }

frequency:	NUMBER			{ frq = ($1)*10; adj = 0; }
	|	NUMBER NUMBER		{ frq = ($1)*10; adj = ($2)*10;}
	|	NUMBER FNUMBER		{ frq = ($1)*10; adj = $2; }

shortname:	NUMBER			{ sprintf(shortName,"%d",(int)$1); }
	|	NAME			{ *shortName = '\000';
                                          strncat(shortName,rctext,3); }

mode:		RADIO			{ $$ = -1; }
	|	PAL			{ $$ =  1; }
	|	NTSC			{ $$ =  0; }

longname:				{ *longName = '\000'; }
	|	STRING			{ char *ptr;
                                          *longName = '\000';
                                          strncat(longName,(char*)rctext+1,21);
                                          ptr = strrchr(longName,'\000');
                                          if (*--ptr == '"') *ptr = '\000'; }

preference:	readonly
	|	externalmute
	|	port
	|	display
	|	source
	|	channel
	|	mode
	|	mute
	|	bass
	|	treble
	|	volume
	|	brightness
	|	saturation
	|	contrast
	|	hue
	|	red
	|	green
	|	blue

readonly:	READONLY		{ RCSettings.readonly = 1; }

externalmute:	EXTERNALMUTE		{ RCSettings.externalMute = 1; }

port:		PORT NUMBER		{ if (!RCSettings.port)
                                            RCSettings.port = $2; }

display:	DISPLAY VGA		{ RCSettings.TVVGA = 0; }
	|	DISPLAY TUNER		{ RCSettings.TVVGA = 1; }

source:		SOURCE TV		{ RCSettings.TVVCR = 1; }
	|	SOURCE VCR		{ RCSettings.TVVCR = 0; }

channel:	CHANNEL NUMBER		{ RCSettings.channel = $2; }

mode:		MODE PAL		{ RCSettings.PALNTSC = 1; }
	|	MODE NTSC		{ RCSettings.PALNTSC = 0; }

mute:		MUTE ON			{ RCSettings.mute = 1; }
	|	MUTE OFF		{ RCSettings.mute = 0; }

bass:		BASS NUMBER		{ RCSettings.bass = fromPercentage
                                          ($2,0,MAXBASS); }
treble:		TREBLE NUMBER		{ RCSettings.treble = fromPercentage
                                          ($2,0,MAXTREBLE); }
volume:		VOLUME NUMBER		{ RCSettings.volume = fromPercentage
                                          ($2,0,MAXVOLUME); }
brightness:	BRIGHTNESS NUMBER	{ RCSettings.brightness =fromPercentage
                                          ($2,DEFBRIGHTNESS,63); }
saturation:	SATURATION NUMBER	{ RCSettings.saturation =fromPercentage
                                          ($2,DEFSATURATION,63); }
contrast:	CONTRAST NUMBER		{ RCSettings.contrast = fromPercentage
                                          ($2,DEFCONTRAST,63); }
hue:		HUE NUMBER		{ RCSettings.hue = fromPercentage
                                          ($2,DEFHUE,255); }
red:		RED NUMBER		{ RCSettings.red = fromPercentage
                                          ($2,DEFRED,63); }
green:		GREEN NUMBER		{ RCSettings.green = fromPercentage
                                          ($2,DEFGREEN,63); }
blue:		BLUE NUMBER		{ RCSettings.blue = fromPercentage
                                          ($2,DEFBLUE,63); }
