/*                                                 -*-mode:C;tab-width:8-*-
 * libdos.c -- source file for dos compatibility functions
 *
 * Copyright (C) 1995 ImageNation Corporation  (Version 1.3)
 * Copyright (C) 1995 Alessandro Rubini  --  rubini@ipvvis.unipv.it
 *
 *   Which licence does this fall into?
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
 
#include "cx100.h" 

int _cxg_fd=-1; /* we need a global file descriptor, to access the board */
char _cxg_ports[4];

void board_on(void)  /* Real IN code */
{
  Cxg_GetBit(_cxg_fd,VERTICAL_BLANK);   /* reading PORT6 turns on the power */
  ClockDelay(1);                                    /* wait while it resets */

  Cxg_Command(_cxg_fd,0x47);                      /* put it in CX100 mode */
  ClockDelay(1);                            /* wait while the ports change */

#if 0 /* MISSING */
  Fd[fg].off = FALSE;
  if(Fd[fg].addr != 0)               /* if there is a prev address, set it */
    set_address(Fd[fg].addr);
  erase_ram();
  set(OVERLAY_ENABLE);
  erase_ram();
  clr(OVERLAY_ENABLE);
#endif

}

char *init_library(void)
{
  static char msg[48];
  if ((_cxg_fd=open("/dev/cxg0",O_RDWR))==-1)
	{
	sprintf(msg,"/dev/cxg0: %s",strerror(errno));
	return msg;
	}
  return NULL;
}

int read_revision(void)  /* by ImageNation */
{
int mp_rev, fpga_rev;

  fpga_rev = cx_command(0x41);
  mp_rev = cx_command(0x42);
  if((fpga_rev > 0) && (mp_rev > 0))
    return ((fpga_rev << 8) + mp_rev);
  else
    return -1;
}

void reset_cx(void)  /* by ImageNation */
{
  Cxg_GetBit(_cxg_fd,CXG_BIT_VBLANK);
  ClockDelay(1);
  clr(IN_LUT_ENABLE);
  clr(OUT_LUT_ENABLE);
  /*  CLEAR_PORTS; */
  cx_command(0x0059);
  set(IN_LUT_ENABLE);
  /* outp(PORT6,0x002F); what? */
  ClockDelay(1);
  cx_command(0x47);
  ClockDelay(1);
#if 0
  Fd[fg].off = FALSE;
  if(Fd[fg].addr != 0)
    set_address(Fd[fg].addr);
  erase_ram();
#endif
  set(OVERLAY_ENABLE);
#if 0
  erase_ram();
#endif
  clr(OVERLAY_ENABLE);
}

  
