/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: X_grafik.h
**
** benoetigt:
**  X11/Xlib.h, global.h, grafik.h
**
** Kommentar:
**  Interne Defines fuer X-Zeichen-routinen
*/


static char sccsid_X_grafik[] = "@(#)X_grafik.h	1.15 03 Oct 1994";


/* Anzahl der Ecken der Augen- und Mundpolygone */
#ifndef AUGENECKENANZ
#define AUGENECKENANZ 32
#endif

#ifndef MUNDECKENANZ
#define MUNDECKENANZ 32
#endif


/* Innen- und Aussenradius des Fadenkreuzes in Fensterhoehe/KREUZ_FAKTOR */
#ifndef KREUZ_INRAD
#define KREUZ_INRAD 4
#endif

#ifndef KREUZ_AUSRAD
#define KREUZ_AUSRAD 10
#endif

#define KREUZ_FAKTOR 256


/* gesammelte Daten zum Zeichnen des Blickfeldes */
struct blickfelddaten
{
	struct objektdaten objekte;
	int fadenkreuz; /* 1, falls Fadenkreuz zu zeichnen */
};

/* gesammelte Daten zum Zeichnen des Grundrisses */
struct grundrissdaten
{
	int anzlinien;
	struct kartenlinie *linien;
	int anzkreise;
	struct kartenkreis *kreise;
	int anzkreise_alt;              /* nur fuer X_zeichne_karte,
	                                   muss sonst 0 sein */
	struct kartenkreis *kreise_alt; /* nur fuer X_zeichne_karte,
	                                   muss sonst NULL sein */
};

struct fenster
{
	Display *display;
	Window window;
	int breite, hoehe;
	unsigned farbtiefe;
};


/* Prototypen fuer globale Funktionen */

#ifdef __STDC__

void X_zeichne_blickfeld(void *X_daten, struct fenster *fenster,
	void *daten);
void X_zeichne_karte(void *X_daten, struct fenster *fenster, void *daten);
void X_zeichne_grundriss(void *X_daten, struct fenster *fenster,
	void *daten);
void X_zeichne_kompass(void *X_daten, struct fenster *fenster, void *daten);
void X_zeichne_punkte(void *X_daten, struct fenster *fenster, void *daten);
int X_farben_init(Display *display, int screen);
void X_zeichne_sync_anfang(Display *display);
void X_zeichne_sync_ende(Display *display);
void X_fenster_init(void **X_daten, struct fenster *fenster);
void X_fenster_freigeben(void **X_daten, struct fenster *fenster);
void X_karte_init(void **X_daten, struct fenster *fenster);
void X_karte_freigeben(void **X_daten, struct fenster *fenster);

#else

void X_zeichne_blickfeld();
void X_zeichne_karte();
void X_zeichne_grundriss();
void X_zeichne_kompass();
void X_zeichne_punkte();
int X_farben_init();
void X_zeichne_sync_anfang();
void X_zeichne_sync_ende();
void X_fenster_init();
void X_fenster_freigeben();
void X_karte_init();
void X_karte_freigeben();

#endif
