/***********************************************************
*  Mirror Magic II -- McDuffins Revenge                    *
*----------------------------------------------------------*
*  1994 Artsoft Development                               *
*        Holger Schemel                                    *
*        33659 Bielefeld-Senne                             *
*        Telefon: (0521) 493245                            *
*        eMail: aeglos@valinor.ms.sub.org                  *
*               aeglos@uni-paderborn.de                    *
*               q99492@pbhrzx.uni-paderborn.de             *
*----------------------------------------------------------*
*  sound.c                                                 *
*                                                          *
*  Letzte Aenderung: 29.09.1994                            *
***********************************************************/

#include "sound.h"
#include "misc.h"

void SoundEventLoop()
{
  struct SoundCtrl snd_ctrl;
  struct SoundHeader *snd_hdr;
  fd_set sound_fdset;

  close(sound_pipe[1]);		/* no writing into pipe needed */

#ifdef hpux
  {
    struct audio_describe ainfo;
    int audio_ctl;

    audio_ctl = open("/dev/audioCtl", O_WRONLY | O_NDELAY);
    if (audio_ctl == -1)
    {
      fprintf(stderr,"%s: cannot open /dev/audioCtl - no sounds\n",progname);
      for(;;)
	Delay(1000000);
    }

    if (ioctl(audio_ctl, AUDIO_DESCRIBE, &ainfo) == -1)
    {
      fprintf(stderr,"%s: no audio info - no sounds\n",progname);
      for(;;)
	Delay(1000000);
    }

    if (ioctl(audio_ctl, AUDIO_SET_DATA_FORMAT, AUDIO_FORMAT_ULAW) == -1)
    {
      fprintf(stderr,"%s: ulaw audio not available - no sounds\n",progname);
      for(;;)
	Delay(1000000);
    }

    ioctl(audio_ctl, AUDIO_SET_CHANNELS, 1);
    ioctl(audio_ctl, AUDIO_SET_SAMPLE_RATE, 8000);

    close(audio_ctl);
  }
#endif /* hpux */

  if ((sound_device=open(sound_device_name,O_WRONLY))<0)
  {
    fprintf(stderr,"%s: cannot open sound device - no sounds\n",progname);
    for(;;)
      Delay(1000000);
  }

  FD_ZERO(&sound_fdset); 
  FD_SET(sound_pipe[0], &sound_fdset);

  for(;;)	/* wait for calls from PlaySound(), StopSound(), ... */
  {
    FD_SET(sound_pipe[0], &sound_fdset);
    select(sound_pipe[0]+1, &sound_fdset, NULL, NULL, NULL);
    if (!FD_ISSET(sound_pipe[0], &sound_fdset))
    {
      FD_SET(sound_pipe[0], &sound_fdset);
      continue;
    }
    if (read(sound_pipe[0], &snd_ctrl, sizeof(snd_ctrl))!=sizeof(snd_ctrl))
    {
      fprintf(stderr,"%s: broken pipe - no sounds\n",progname);
      for(;;)
	Delay(1000000);
    }

    if (!snd_ctrl.stop)
    {
      struct timeval no_delay = { 0, 0 };
      unsigned long todo = Sound[snd_ctrl.nr].len, done=0;
      char *bufptr;
      unsigned long bufsize;
      unsigned long sample_rate;
      long delay = Counter2()-1;

      snd_hdr = (struct SoundHeader *)Sound[snd_ctrl.nr].buf;
      sample_rate = be2long(&snd_hdr->sample_rate);

      while(done<todo &&
	    select(sound_pipe[0]+1,&sound_fdset,NULL,NULL,&no_delay)<1)
      {	
	if (delay>Counter2())
	  continue;

	FD_SET(sound_pipe[0], &sound_fdset);
	bufptr=Sound[snd_ctrl.nr].buf+done;
	bufsize=MIN(BLOCKSIZE,todo-done);
	done+=write(sound_device,bufptr,bufsize);

	delay = Counter2()+(bufsize*1000*80)/(sample_rate*100);

/*
	delay.tv_sec=0;
	delay.tv_usec=((bufsize*1000*80)/(sample_rate*100))*1000;
*/
      }       

      close(sound_device);
      if ((sound_device=open(sound_device_name,O_WRONLY))<0)
      {
	fprintf(stderr,"%s: cannot open sound device - no sounds\n",progname);
	for(;;)
	  Delay(1000000);
      }
    }
  }
}

/****************************************************************/
/* void PlaySound(int ch, int nr, int sp)			*/
/*--------------------------------------------------------------*/
/* ch: Soundkanal						*/
/* nr: Soundnummer in Soundliste 				*/
/* sp: Abspieltempo in % (sp==0: Endlosschleife) 		*/
/****************************************************************/

void PlaySound(int ch, int nr, int sp)
{
  struct SoundCtrl snd_ctrl;

  if (sound_status==SOUND_OFF || !sound_on)
    return;

  snd_ctrl.nr=nr;
  snd_ctrl.channel=ch;
  snd_ctrl.loop=(sp==0);
  snd_ctrl.stop=FALSE;

  if (write(sound_pipe[1], &snd_ctrl, sizeof(snd_ctrl))<0)
  {
    fprintf(stderr,"%s: cannot pipe to child process - no sounds\n",progname);
    sound_status=SOUND_OFF;
    return;
  }
}

void StopSound(int ch)
{
  struct SoundCtrl snd_ctrl;

  if (sound_status==SOUND_OFF)
    return;

  snd_ctrl.stop=TRUE;

  if (write(sound_pipe[1], &snd_ctrl, sizeof(snd_ctrl))<0)
  {
    fprintf(stderr,"%s: cannot pipe to child process - no sounds\n",progname);
    sound_status=SOUND_OFF;
    return;
  }
}

void StopSounds()
{
  int ch;
  for(ch=0;ch<4;ch++) 
    StopSound(ch);
}

void FadeSound(ch)
int ch;
{
  StopSound(ch);
}

BOOL LoadSound(int nr)
{
  FILE *file;
  char filename[300];

  static char *sound_name[NUM_SOUNDS] =
  {
    "amoebe",
    "antigrav",
    "autsch",
    "bong",
    "fuel",
    "halloffame",
    "holz",
    "hui",
    "kabumm",
    "kink",
    "kling",
    "laser",
    "oeffnen",
    "quiek",
    "rhythmloop",
    "roaaar",
    "sirr",
    "slurp",
    "voyager",
    "warnton",
    "whoosh"
  };

  Sound[nr].name=sound_name[nr];
  sprintf(filename,"%s/%s.au",SND_PATH,sound_name[nr]);

  if (!(file=fopen(filename,"r")))
  {
    fprintf(stderr,"%s: cannot open sound file '%s' - no sounds\n",
	    progname,filename);
    return(FALSE);
  }

  if (fseek(file,0,SEEK_END)<0)
  {
    fprintf(stderr,"%s: cannot read sound file '%s' - no sounds\n",
	    progname,filename);
    fclose(file);
    return(FALSE);
  }

  Sound[nr].len=ftell(file);
  rewind(file);

  if (!(Sound[nr].buf=malloc(Sound[nr].len)))
  {
    fprintf(stderr,"%s: out of memory (this shouldn't happen :) - no sounds\n",
	    progname);
    fclose(file);
    return(FALSE);
  }

  if (fread(Sound[nr].buf,1,Sound[nr].len,file)!=Sound[nr].len)
  {
    fprintf(stderr,"%s: cannot read sound file '%s' - no sounds\n",
	    progname,filename);
    fclose(file);
    return(FALSE);
  }

  fclose(file);
  return(TRUE);
}

void FreeSounds()
{
  int i;

  for(i=0;i<NUM_SOUNDS;i++)
    free(Sound[i].buf);
}
