
/***********************************************************
*                      K O U L E S                         *
*----------------------------------------------------------*
*  C1995 JAHUSOFT                                          *
*        Jan Hubicka                                       *
*        Dukelskych Bojovniku 1944                         *
*        390 03 Tabor                                      *
*        Czech Republic                                    *
*        Telefon: (048-I think) (0361) 32613               *
*        eMail: hubicka@limax.paru.cas.cz                  *
*----------------------------------------------------------*
* Copyright(c)1995 by Jan Hubicka.See README for license   *
*                          details.                        *
*----------------------------------------------------------*
*  koules.h                                                *
***********************************************************/

#ifndef __KOULE_INCLUDED___
#define __KOULE_INCLUDED___
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <fcntl.h>
#include <vga.h>
#include <vgagl.h>
#include <vgakeyboard.h>
#include <vgamouse.h>
#include <sys/soundcard.h>
#include "soundIt.h"
#ifdef JOYSTICK
#include <linux/joystick.h>
#endif

#define MENUTIME 5

#if G640x480
#define VGAMODE G640x480x256
#define PLAY_X2 640
#define gl_disableclipping()
#define PLAY_Y2 460
#define GAMEWIDTH (PLAY_X2-PLAY_X1)
#define GAMEHEIGHT (PLAY_Y2-PLAY_Y1)
#define MAPWIDTH (PLAY_X2-PLAY_X1)
#define MAPHEIGHT (PLAY_Y2-PLAY_Y1)
#define DIV 1
#define EYE_RADIUS 5
#define MOUSE_RADIUS 4
#elif G320x200
#define VGAMODE G320x200x256
#define PLAY_X2 640
#define PLAY_Y2 360
#define GAMEWIDTH (PLAY_X2-PLAY_X1)
#define GAMEHEIGHT (PLAY_Y2-PLAY_Y1)
#define MAPWIDTH (320)
#define MAPHEIGHT (180)
#define DIV 2
#define EYE_RADIUS 6
#define MOUSE_RADIUS 4
#else
#error  graphics mode not set please edit makefile!!!!!
#endif


#define back(x) (32 + x)
#define ball(x) (64 + x)
#define rocket(x) (96 + x)


#define PLAY_X1 0
#define PLAY_Y1 0




#define RAD(n)  ((float)(n)/180.0*M_PI)
#define ROTSTEP RAD(20)


#define BALL_RADIUS 8
#define BBALL_RADIUS 16
#define APPLE_RADIUS 32
#define INSPECTOR_RADIUS 14
#define HOLE_RADIUS 12
#define ROCKET_RADIUS 14
#define EYE_RADIUS1 10


#define NTRACKS 4
#define NTRACKS 4
#define ROCKET 1
#define BALL 2


#define LBALL 3
#define CREATOR 4
#define HOLE 5
#define BBALL 6
#define APPLE 7
#define INSPECTOR 8
#define EHOLE 9


#define MAXOBJECT 500
#define MAXPOINT (4000/DIV/DIV)
#define MAXROCKETS 5


#define L_ACCEL 'A'
#define L_SPEED 'S'
#define L_GUMM 'M'
#define A_ADD 0.13
#define M_ADD 0.8


#define LETTER 1024


#define S_START 0
#define S_END 1
#define S_COLIZE 2
#define S_DESTROY_BALL 3
#define S_DESTROY_ROCKET 4
#define S_CREATOR1 5
#define S_CREATOR2 6

#define DEATHMATCH 0
#define COOPERATIVE 1


#define NSAMPLES 7

#define MENU 1
#define KEYS 2
#define GAME 3
#define JOY 4


#define next ((++cit)>=NTRACKS?cit=1:cit)


typedef struct
  {
    int             type;
    int             ctype;
    int             live;
    int             time;
    int             score;
    float           x;
    float           y;
    float           fx;		/*forces */
    float           fy;
    float           rotation;	/*for rockets */
    int             live1;	/*backup for rockets */
    float           M;
    int             radius;
    float           accel;
    char            letter;
  }
Object;
typedef struct
  {
    int             x, y, xp, yp, time, color;
  }
Point;

typedef struct
  {
    char           *text;
    void            (*func) ();
  }
Menu;


#ifndef VARIABLES_HERE
extern float    ROCKET_SPEED;
extern float    BALL_SPEED;
extern float    BBALL_SPEED;
extern float    SLOWDOWN;
extern float    GUMM;

extern float    BALLM;
extern float    LBALLM;
extern float    BBALLM;
extern float    APPLEM;
extern float    INSPECTORM;
extern float    ROCKETM;


extern int      nobjects;
extern int      textcolor;
extern int      nrockets;
extern Object   object[MAXOBJECT];
extern Point    point[MAXPOINT];
extern int      gameplan;
extern int      rotation[MAXROCKETS];

extern int      mouseplayer;
#ifdef JOYSTICK
extern int      joystickplayer[2];
extern int      joystickdevice[2];
extern int      calibrated[2];
extern int      center[2][2];
#endif


extern GraphicsContext *physicalscreen;
extern GraphicsContext *backscreen;
extern GraphicsContext *background;
extern int      cit;
extern int      gamemode;
extern int      nmenu;
extern int      tbreak;
extern Menu     menu[20];

extern int      a_bballs, a_rockets, a_balls, a_holes, a_apples, a_inspectors,
                a_eholes;

extern int      keys[5][4];
extern int      sound;

void           *fontblack;
void           *fontwhite;

#endif
extern char    *files[NSAMPLES];

extern inline void
normalize (float *x, float *y, float size)
{
  float           length = sqrt ((*x) * (*x) + (*y) * (*y));
  if (length == 0)
    length = 1;
  *x *= size / length;
  *y *= size / length;
}


extern void     addpoint (int, int, int, int, int, int);
extern void     destroy (int);
extern void     creator (int);
extern void     creator_rocket (int);
extern void     uninitialize ();
extern int
find_possition (float *, float *, float)
                __attribute ((const));
     extern int      radius (int) __attribute ((const));
     extern float    M (int) __attribute ((const));



     extern void     draw_menu (int);
     extern void     draw_joy (int);
     extern void     init_menu ();
     extern void     menu_keys ();

     extern void     draw_keys (int);
     extern void     keys_keys ();
     extern void     joy_keys ();
     extern void     gameplan_init ();

     extern void     rocket_destroyed (int);
     extern int      create_letter () __attribute ((const));
     extern void     update_game ();
     extern void     init_objects ();
     extern void     outro1 ();
     extern void     outro2 ();
     extern void     clearpoints ();
     extern void     intro_intro ();
     extern void     hole_intro ();
     extern void     inspector_intro ();
     extern void     bball_intro ();
     extern void     bbball_intro ();
     extern void     maghole_intro ();
     extern void     fadeout ();
     extern void     fadein ();



#endif
