// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// a layer on top of the svgalib library.
// Routines to setup the initialize the screen/svgalib/etc, restore back
// to text when all done, throw up a few messages/prompts, get simple
// string input from the user, etc..


#ifndef __Ui__
#define __Ui__

#include <stdio.h>
#include <vgagl.h>
#include <vga.h>
#include <iostream.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>

#include "str.h"

unsigned char gamefont01[2048];
unsigned char gamefont02[2048];

class Ui {

    public:
    
    	static void updateScreen();
    	static void drawToPhysical();
    	static void drawToVirtual();
    
    	static void init();
    	
	static void restore();

	static void message( int y, const char *msg ); // message centered at line y
	static void message( const char *msg )
		{ message( (HEIGHT-fontHt)>>1, msg ); }
	
	static char yesNo( const char *msg );
	
	// returns last key pressed (eg. CR or ESC)
	static int input( int x, int y, char *inp, int len );
	static int input( int x, int y, char *prompt, char *inp, int len )
		{ 
		gl_write( x, y, prompt ); 
		return Ui::input( x+strlen(prompt)*Ui::fontW, y, inp, len );
		}
    
        static int fontWidth()  { return fontW; }
        static int fontHeight() { return fontHt; }

	static GraphicsContext backscreen;

    private:
  
  	static void die(int);	/* trap signals to die() for graceful exit */

    	static void initFont();

	static void drawCursor(int x, int y);
	static void hideCursor(int x, int y);
  
	//static GraphicsContext backscreen;
	static GraphicsContext physicalscreen;
	  
	static int vgaMode;
	static int virtualScn;
    
    	static int fontHt;
    	static int fontW;
  
  	static struct termios old;
    };


// update physical screen from virtualScn
inline void Ui::updateScreen() { gl_copyscreen(&physicalscreen); }

// set drawing to physical screen
inline void Ui::drawToPhysical() { gl_setcontext(&physicalscreen); }

#endif
