/* --------------------------------- config.h ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* System dependent configuration information: MSDOS, Borland c2
*/

#include <string.h>

#define FLY8_BC2	1
#define FLY8_BC		1

#define	INIFILE	"fly.ini"	/* name of ini file */
#define	LOGFILE	"fly.log"	/* name of log file */
#define MAC_EXT "mac"		/* binary macros file extension */
#define MAX_EXT "max"		/* text macros file extension */
#define VMD_EXT "vmd"		/* video modes file extension */
#define PRM_EXT "prm"		/* plane parameters file extension */
#define SHP_EXT "vxx"		/* object shape file extension */
#define NAV_EXT "nav"		/* nav data file extension */
#define LND_EXT "lnd"		/* landscape file extension */

#define	RTMODE	"rt"		/* fopen file mode: read  text */
#define	RBMODE	"rb"		/* fopen file mode: read  binary */
#define	WTMODE	"wt"		/* fopen file mode: write text  */
#define	WBMODE	"wb"		/* fopen file mode: write binary */
#define	ATMODE	"at"		/* fopen file mode: read/write text */
#define	ABMODE	"ab"		/* fopen file mode: read/write binary */

#define PATHSEP	';'		/* path separator */

#define	FAR		far
#define NEAR		near
#define FASTCALL
#define CDECL		_cdecl
#ifndef _LOADDS_
#define _LOADDS_
#endif

#define C_MAIN	main

#define INLINED

#define FAULT_OFFSET		9		/* word count! */
#define MULDIV_OFFSET		(FAULT_OFFSET+3)

#define HAVE_JOYSTICK
