/*
 * VGA 16 colour mode support routines
 *
 * Copyright (C) Evan Harris, 1993, 1994, 1995.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#ifdef USEGETPIXEL
#include <vga.h>
#endif

int vga16_init(void);
void vga16_setpixel(int color, int x, int y);
void vga16_text(int x, int y, char *s, int fg, int bg);
void vga16_filledblock(int x0, int y0, int x1, int y1, int color);

#ifndef USEGETPIXEL
void vga16_drawscansegment(unsigned char *colors, int x, int y, int length);
void vga16_drawscanline(int y, unsigned char *colors);
int vga16_getpixel(int x, int y);
#else
#define vga16_drawscansegment vga_drawscansegment
#define vga16_drawscanline vga_drawscanline
#define vga16_getpixel vga_getpixel
#endif

#define vga16_waitretrace vga_waitretrace
