/*
 * Imperium
 *
 * Copyright (C) 1990-93 by David Wright
 *
 * $Id: Scan.h,v 3.4.1.1 1993/11/19 06:23:03 davewt Exp $
 *
 * Feel free to modify and use these sources however you wish, so long
 * as you preserve this copyright notice.
 *
 * $Log: Scan.h,v $
 * Revision 3.4.1.1  1993/11/19  06:23:03  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:01:48  davewt
 * New revision.
 *
 * Revision 3.3  1993/10/16  04:33:46  davewt
 * New  release.
 *
 * Revision 3.2  1993/10/07  02:06:55  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:52:32  davewt
 * patch1: First patch to initial version.
 *
 *
 */

#define MAX_CONDITIONS  8               /* max # '?' conditions     */
#define MAX_SHIPS       32              /* max # specific ships     */
#define MAX_PLANETS     32              /* max # specific planets   */
#define MAX_MINERS      32              /* max # specific miners    */


typedef struct
    {
        long
            c_left;
        long
            c_right;
        char
            c_operator;
    } Condition_t;

#define shp_none    0                   /* no conditions            */
#define shp_list    1                   /* list of ship numbers     */
#define shp_box     2                   /* sectors they are in      */
#define shp_fleet   3                   /* a fleet they are in      */
#define shp_plList  4                   /* list of planet numbers   */
typedef UBYTE ShipPattern_t;

#define pp_none     0                   /* no conditions            */
#define pp_list     1                   /* list of planet numbers   */
#define pp_box      2                   /* sectors they are in      */
typedef UBYTE PlanetPattern_t;

#define mnp_none    0                   /* no conditions            */
#define mnp_list    1                   /* list of miner numbers    */
#define mnp_box     2                   /* sectors they are in      */
#define mnp_shList  3                   /* list of ship numbers     */
#define mnp_plList  4                   /* list of planet numbers   */
typedef UBYTE MinerPattern_t;

typedef struct
    {
        USHORT
            cs_conditionCount;
        Condition_t
            cs_condition[MAX_CONDITIONS];
        USHORT
            cs_boxTop,
            cs_boxBottom,
            cs_boxLeft,
            cs_boxRight;
    } ConditionSet_t;

typedef struct
    {
        ConditionSet_t
            shs_cs;
        ShipPattern_t
            shs_shipPatternType;
        ULONG
            shs_shipCount;
        ULONG
            shs_shipList[MAX_SHIPS];
        UBYTE
            shs_shipFleet;
        Ship_t
            shs_currentShip;
    } ShipScan_t;

typedef struct
    {
        ConditionSet_t
            ps_cs;
        PlanetPattern_t
            ps_planetPatternType;
        ULONG
            ps_planetCount;
        ULONG
            ps_planetList[MAX_PLANETS];
        Planet_t
            ps_currentPlanet;
    } PlanetScan_t;

typedef struct
    {
        ConditionSet_t
            ss_cs;
        Sector_t
            ss_currentSector;
        BOOL
            ss_mapHook;
    } SectorScan_t;

typedef struct
    {
        ConditionSet_t
            mns_cs;
        MinerPattern_t
            mns_minerPatternType;
        ULONG
            mns_minerCount;
        ULONG
            mns_minerList[MAX_MINERS];
        Ship_t
            mns_currentMiner;
    } MinerScan_t;

