case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Clients/Makefile (with variable substitutions)"
$spitshell >Makefile <<!GROK!THIS!
IMP_DEST = $installprivlib
IMP_BIN_DEST = $installbin
IMP_OWN=$impown
IMP_GRP=$impgrp
IMP_BR=$baserev

# Cflags Options:
#
# BROKEN_PIPE - If your open() command needs O_RDWR instead of O_RDONLY
#
# TERMIO - If your system uses "termio.h"
#
# TERMIOS - If your system uses "termios.h"
#
# BROKEN_MKNOD - If your system's mknod() does not set the mode flags you
#                request.

CC = $cc
CFLAGS = $warnflags -DBROKEN_PIPE -DTERMIOS -DBROKEN_MKNOD $ccflags
DEBUG = $optimize
LDFLAGS = $ldflags

# Imperium library link targets
IMPLIB = $implinklib
LIB_TARG = $implinktarg
CRYPTLIB = $cryptlib

LN = $ln -s
RM = $rm -f
ETAGS = $etags


!GROK!THIS!

case "$installpgm" in
ninstall)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = ../$fullinstallpgm
!GROK!THIS!
;;
*)
$spitshell >>Makefile <<!GROK!THIS!
INSTALL = $fullinstallpgm
!GROK!THIS!
;;
esac

$spitshell >>Makefile <<'!NO!SUBS!'

IMPINC = ../Include/ImpLib.h
IMPREQINC = ../Include/Request.h
IMPPRAG = ../Include/ImpPragmas.h

INCFILES = $(IMPINC) $(IMPREQINC)

ALLFLAGS = $(DEBUG) $(CFLAGS) -DFIFO_DIR="\"$(IMP_DEST)/fifo\"" -DIMP_BASE_REV="\"$(IMP_BR)\""

.c.o:
	@echo "Working on $*.c"
	@$(CC) $(ALLFLAGS) -c -o $*.o $<

all: ConImp

ConImp: ConImp.o $(IMPLIB)
	@echo "Linking ConImp"
	@$(CC) $(LDFLAGS) -o ConImp ConImp.o $(IMPLIB) -lc $(CRYPTLIB)

ConImp.o: ConImp.c $(INCFILES) ../config.h ../patchlevel.h ../impsec.h

$(IMPLIB):
	cd ../Library;./doMake $(LIB_TARG)

../impsec.h:
	cd ..;./gSCodes

TAGS:
	$(ETAGS) -t *.c ../Include/*.h

clean:
	-$(RM) ConImp ConImp.o

install: ConImp
	$(INSTALL) -d -g $(IMP_GRP) -m 755 -o $(IMP_OWN) $(IMP_DEST)/clients
	$(INSTALL) -g $(IMP_GRP) -m 711 -o $(IMP_OWN) ConImp $(IMP_DEST)/clients
	-$(RM) $(IMP_BIN_DEST)/ConImp
	$(LN) $(IMP_DEST)/clients/ConImp $(IMP_BIN_DEST)/ConImp
!NO!SUBS!
chmod 644 Makefile
$eunicefix Makefile
