/* match.h */


#include "copyright.h"

#include "db.h"

/* match constants */
#ifdef DO_GLOBALS
#define NORMAL_MATCH 0
#define GLOBAL_MATCH 1
#define REMOTE_MATCH 2
#endif

/* match functions */
/* Usage: init_match(player, name, type); match_this(); match_that(); ... */
/* Then get value from match_result() */

/* initialize matcher */
extern void init_match();
extern void init_match_check_keys();
/* match (LOOKUP_TOKEN)player */
extern void match_player();
/* match (NUMBER_TOKEN)number */
extern void match_absolute();
/* match (NUMBER_TOKEN)number, with a control check */
extern void match_controlled_absolute();
/* match "me" */
extern void match_me();
/* match "here" */
extern void match_here();
/* match the name of the player's container */
extern void match_here();
/* match something player is carrying */
extern void match_possession();
/* match something in the same room as player */
extern void match_neighbor();
/* match an exit from player's room */
extern void match_exit();
/* all of the above, except only Wizards do match_absolute and match_player */

#ifdef DO_GLOBALS
/* master room match */
extern void init_match_global();
/* master room match, check keys */
extern void init_match_global_check_keys();
/* remote matching */
extern void init_match_remote();
extern void match_remote();
extern void match_remote_contents();
#endif

extern void match_everything();
/* wrapper for match_everything with control check */
extern dbref match_controlled();

/* similar to match_everything but doesn't match #dbrefs or *player for
 * non-priv'ed players. match_near_things also doesn't match exits.
 */
extern void match_nearby();
extern void match_near_things();

/* return match results */
extern dbref match_result();	/* returns AMBIGUOUS for multiple inexacts */
extern dbref last_match_result();	/* returns last result */
extern dbref noisy_match_result();	/* wrapper for match_result */

