#ifndef _ATTRIB_H
#define _ATTRIB_H

/* hash table size constant */
#define ATR_HASH_SIZE 128
#define ATR_HASH_MASK 127

/* new attribute foo */
typedef struct attr ATTR;

/* the attribute structure */
struct attr {
   char *name;				/* name of attribute */
   int flags;
   char *value;
   int creator;
};

struct boolatr {
  char *name;	                      /* which attribute? */
  char *text;
};

/* possible attribute flags */
#define AF_ODARK	0x1	/* players other than owner can't see it */
#define AF_DARK		0x2	/* no one can see it */
#define AF_WIZARD	0x4	/* Wizard only can change it */
#define AF_NUKED	0x8	/* marked for deletion from attrib list */
#define AF_LOCKED	0x10	/* Only creator of attrib can change it. */
#define AF_NOPROG	0x20	/* won't be searched for $ commands. */
#define AF_MDARK        0x40    /* Only wizards can see it */
#define AF_PRIVATE      0x80    /* Children don't inherit it */
#define AF_NOCOPY       0x100   /* atr_cpy (for @clone) doesn't copy it */

/* external predefined attributes. */
extern ATTR attr[];

/* easy access macros for attributes */
#define s_Osucc(thing,s) atr_add(thing, "OSUCCESS", (s), (thing), NOTHING)
#define s_Ofail(thing,s) atr_add(thing, "OFAILURE", (s), (thing), NOTHING)
#define s_Fail(thing,s) atr_add(thing, "FAILURE", (s), (thing), NOTHING)
#define s_Succ(thing,s) atr_add(thing, "SUCCESS", (s), (thing), NOTHING)
#define s_Pass(thing,s) atr_add(thing, "XYXXY", (s), GOD, NOTHING)
#define s_Desc(thing,s) atr_add(thing, "DESCRIBE", (s), (thing), NOTHING)

#define Astr(attrib) ((attrib)->value)

typedef struct alist ALIST;

struct alist {
  ALIST *next;
  ATTR *attrib; 
};

#define AL_ATTR(alist)		((alist)->attrib)
#define AL_NAME(alist)		(AL_ATTR((alist))->name)
#define AL_STR(alist)		(Astr(AL_ATTR((alist))))
#define AL_NEXT(alist)		((alist)->next)
#define AL_CREATOR(alist)	(AL_ATTR((alist))->creator)
#define AL_FLAGS(alist)		(AL_ATTR((alist))->flags)
#define AL_BAD(alist)		(AL_FLAGS((alist)) & AF_NUKED)

#define AL_DISPOSE(alist)	(AL_FLAGS((alist)) |= AF_NUKED)

#endif  /* __ATTRIB_H */
