#ifndef lint
static char *RCSid = "$Header: /SRX/empite/EMP/player/commands/scut.c 1.0 90/03/23 19:47:24 bailey Exp $";
#endif /* not lint */

/*
 * scut.c
 *
 * Scuttle ships or planes
 * Taken from scra.c
 */

#include "misc.h"
#include "sect.h"
#include "news.h"
#include "var.h"
#include "xy.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

#ifdef	SCUTTLE

union item_u {
	struct shpstr ship;
	struct plnstr plane;
};

scut()
{
	extern	char *argp[];
	struct	nstr_item ni;
	union	item_u item;
	int	type;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	char	*p;
#ifdef TRADESHIPS
	float	cash;
	int	dist;
	struct	sctstr sect;
	struct  natstr *natp;
	char	m1[80],m2[80];
	int	scuttled;
	extern	int   trade_1_dist;	/* less than this gets no money */
	extern	int   trade_2_dist;	/* less than this gets trade_1 money */
	extern	int   trade_3_dist;	/* less than this gets trade_2 money */
	extern	float trade_1;		/* return on trade_1 distance */
	extern	float trade_2;		/* return on trade_2 distance */
	extern	float trade_3;		/* return on trade_3 distance */
	extern	float trade_ally_bonus;	/* 20% bonus for trading with allies */
	extern	float trade_ally_cut;	/* 10% bonus for ally you trade with */
#endif /* TRADESHIPS */
	struct  nstr_item ni2;
	struct  plnstr plane;
	struct	sctstr sect2;

#ifdef TRADESHIPS
	bzero(m1,80);
	bzero(m2,80);
#endif /* TRADESHIPS */
	if ((p = getstarg(argp[1], "Ship or plane? ")) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type == EF_SECTOR)
		type = EF_SHIP;
	if (type != EF_SHIP && type != EF_PLANE) {
		pr("Ships or planes only!\n");
		return RET_SYN;
	}
	if ((p = getstarg(argp[2], fmt("%s(s)? ", ef_nameof(type)))) == 0)
		return RET_SYN;
	if (!snxtitem(&ni, type, p))
		return RET_SYN;
	if (p && (isalpha(*p) || (*p == '*') || (*p == '~'))){
		char y_or_n[80],*ppp=(char *)0, bbuf[80];

		bzero(y_or_n,80);
		if (type == EF_SHIP)
			if (*p == '*')
				sprintf(bbuf,"all ships");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned ships");
			else
				sprintf(bbuf,"fleet %c",*p);
		else
			if (*p == '*')
				sprintf(bbuf,"all planes");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned planes");
			else
				sprintf(bbuf,"wing %c",*p);
		while (!ppp || ((*ppp != 'y') && (*ppp != 'n'))){
			if (type == EF_SHIP)
				ppp = getstarg(y_or_n,fmt("Really scuttle %s? ", bbuf));
			else
				ppp = getstarg(y_or_n,fmt("Really scuttle %s? ", bbuf));
			if (isupper(*ppp))
				*ppp=tolower(*ppp);
		}

		if (*ppp != 'y')
			return RET_FAIL;
	}
	while (nxtitem(&ni, (char *)&item)) {
#ifdef TRADESHIPS
		pr(m1);
		pr(m2);
		bzero(m1,80);
		bzero(m2,80);
		scuttled = 0;
#endif /* TRADESHIPS */
		if (!owner)
			continue;
		if (type == EF_SHIP) {
			mp = &mchr[item.ship.shp_type];
			pr(mp->m_name);
#ifdef	SHIPNAMES
			pr(" ");
			pr(item.ship.shp_name);
#endif	SHIPNAMES
#ifdef TRADESHIPS
			getsect(item.ship.shp_x,item.ship.shp_y,&sect);
			if ((mp->m_flags & M_TRADE) &&
				(sect.sct_type == SCT_HARBR)){

				if (!sect.sct_own){
					scuttled=1;
					item.ship.shp_own = 0;
					putship(item.ship.shp_uid,
						(char *)&item.ship);
					continue;
				}
				natp = getnatp(sect.sct_own);
				dist = mapdist(item.ship.shp_x, item.ship.shp_y,
					item.ship.shp_orig_x,
					item.ship.shp_orig_y);
				if (dist < trade_1_dist){
					sprintf(m2,"This port is too close to ship's home port to make a profit, sorry.\n");
					cash = 0;
				}
				else if (dist < trade_2_dist)
					cash = (1.0 + trade_1*((float)dist));
				else if (dist < trade_3_dist)
					cash = (1.0 + trade_2*((float)dist));
				else
					cash = (1.0 + trade_3*((float)dist));
				cash *= mp->m_cost;
				cash *= (((float)item.ship.shp_effic) / 100.0);
				sprintf(m1,"Ship has gone %d sects\n",dist);

				if (sect.sct_own != item.ship.shp_own){
					cash *= (1.0 + trade_ally_bonus);
					NAT_DELTA(nat_money, sect.sct_own, (int)(cash * trade_ally_cut));
					wu(0,sect.sct_own,fmt("Trade with %s nets you %f at %s\n",cname(item.ship.shp_own),(cash/10),xyas(sect.sct_x,sect.sct_y,sect.sct_own)));
					if (item.ship.shp_own != item.ship.shp_orig_own){
						nreport(item.ship.shp_own,
						N_PIRATE_TRADE,
						item.ship.shp_orig_own, 1);
					}
					else{
						nreport(item.ship.shp_own,
						N_TRADE, sect.sct_own, 1);
					}
				}
				else{
					if (item.ship.shp_own != item.ship.shp_orig_own)
						nreport(item.ship.shp_own,
						N_PIRATE_KEEP,
						item.ship.shp_orig_own, 1);
				}
				dolcost -= cash;
			}
			scuttled=1;
#endif /* TRADESHIPS */
			getsect(item.ship.shp_x,item.ship.shp_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (char *)&plane))
				if (plane.pln_ship == item.ship.shp_uid){
					if (sect2.sct_own != cnum){
						wu(0,cnum,fmt("Plane %d scuttled in %s\n",ni2.cur,xyas(plane.pln_x, plane.pln_y,cnum)));
						plane.pln_own = 0;
					}
					else{
						wu(0,cnum,fmt("Plane %d transferred off ship %d to %s\n",ni2.cur,item.ship.shp_uid,xyas(plane.pln_x, plane.pln_y,cnum)));
						plane.pln_ship = -1;
					}
					putplane(plane.pln_uid, (char *)&plane);
				}
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (char *)&item.ship);
		} else {
			pp = &plchr[item.plane.pln_type];
			pr(pp->pl_name);
#ifdef TRADESHIPS
			scuttled=1;
#endif /* TRADESHIPS */
			if (item.plane.pln_ship >= 0){
				struct shpstr ship;
				getship(item.plane.pln_ship,&ship);
				take_plane_off_ship(&item.plane,&ship);
			}
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (char *)&item.plane);
		}
#ifdef TRADESHIPS
		if (scuttled){
#endif /* TRADESHIPS */
#ifdef	SHIPNAMES
			pr(fmt("(#%d) scuttled in %s\n", ni.cur,
#else
			pr(fmt(" #%d scuttled in %s\n", ni.cur,
#endif	SHIPNAMES
				xyas(item.ship.shp_x, item.ship.shp_y , cnum)));
#ifdef TRADESHIPS
		}
#endif /* TRADESHIPS */
	}
#ifdef TRADESHIPS
	pr(m1);
	pr(m2);
	bzero(m1,80);
	bzero(m2,80);
#endif /* TRADESHIPS */
	return RET_OK;
}

#endif	SCUTTLE
