#include <stdio.h>
#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/rout.c,v 1.7 89/09/02 02:38:29 mr-frog Exp $";
#endif

/*
 * rout.c
 *
 * Show empire delivery routes and (formerly) contracts
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "nat.h"
#include "nsc.h"
#include "sect.h"
#include "item.h"
#include "path.h"
#include "file.h"
#include "map.h"

int
rout()
{
	extern	char	*argp[];
	struct	ichrstr	*ip;
	struct	nstr_sect ns;
	struct	natstr	*natp;
	struct	sctstr	sect;
	struct	nscstr	cond[NS_NCOND];
	int	ncond;
	char	*p, buf[MAPWIDTH(3)+10];
	char	map[WORLD_Y][MAPWIDTH(3)];
	struct	range	relrange;
	int	row;
	int	y;
	int	ry;
	int     i_del;
	int	dir;
	char	what[64];
	char	*str;


	if ((ip = whatitem(argp[1], "What item? ")) == 0)
		return RET_SYN;
	i_del = V_DEL(ip-ichr);
	if(argp[2] == (char *) 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return RET_SYN;
	}
	else {
		str = argp[2];
	}
	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	}
	else
	if (!snxtsct(&ns, str))
		return RET_FAIL;
	ncond = ns.ncond;
	bcopy((char *)ns.cond, (char *)cond, sizeof(struct nscstr) * ncond);
	ns.ncond = 0;

	natp = getnatp(cnum);
	xyrelrange(natp, &ns.range, &relrange);
	bzero(map,sizeof(map));
	blankfill((char *)map, &ns.range, 3);
	border(&relrange, "     ", " ");

	while (nxtsct(&ns, &sect)) {
		if (!owner)
			continue;
		p = &map[ns.dy][ns.dx*2];
		if ((dir = getvar(i_del, (char *)&sect, EF_SECTOR) & 0x7) &&
		    nstr_exec(cond, ncond, (char *)&sect, EF_SECTOR))
			bcopy(routech[dir][0], p, 3);
		p[1] = dchr[sect.sct_type].d_mnem;
	}
	for (row = 0, y = ns.range.ly; row < ns.range.height; y++,row++) {
		ry = yrel(natp, y);
		bzero(buf,sizeof(buf));
		sprintf(buf,"%4d ",ry);
		bcopy(map[row],buf+5,ns.range.width*2+1);
		sprintf(buf+5+ns.range.width*2+1," %-4d\n",ry);
		pr(buf);
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&relrange, "     ", " ");
	return RET_OK;
}
