#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/repo.c,v 1.16 89/09/17 17:47:31 mr-frog Exp $";
#endif /* not lint */

/*
 * repo.c
 *
 * report of comparative tech levels for the various
 * nations based on current nation's tech levels
 *
 * Keith Muller, 1983
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#ifdef REREAD
#include <fcntl.h>
#include <ctype.h>
#endif /* REREAD */

static	printdiff();

struct stats {
	float res;
	float tech;
	float edu;
	int stat;
};

repo()
{
	extern	char *argp[];
	struct	natstr *natp;
	struct	stats mystat;
	struct	natstr nat;
	struct	nstr_item ni;
	int	first;

#ifdef REREAD
        /* Force a complete re-read of nation file, I hope --ts */
        ef_close(EF_NATION);
        ef_open(EF_NATION, O_RDONLY, EFF_MEM);
#endif /* REREAD */
	if (!snxtitem(&ni, EF_NATION, argp[1]))
		return RET_SYN;
	natp = getnatp(cnum);
	mystat.res = natp->nat_level[NAT_RLEV];
	mystat.tech = natp->nat_level[NAT_TLEV];
	mystat.edu = natp->nat_level[NAT_ELEV];
	mystat.stat = natp->nat_stat;
	if ((mystat.stat & STAT_NORM) == 0) {
		mystat.res = -301.0;
		mystat.tech = -301.0;
		mystat.edu = -301.0;
	}
	first = 1;
	while (nxtitem(&ni, (char *) &nat)) {
		if ((nat.nat_stat & STAT_INUSE) == 0)
			continue;
		if (cnum == (natid)ni.cur && !god)
			continue;
		if (first) {
			repo_header();
			first = 0;
		}
		repo_list(&mystat, (natid)ni.cur, &nat);
	}
	return RET_OK;
}

static
repo_header()
{
	pr(" #    name             tech     research    education ");
	if (god)
		pr("happiness cap-location\n");
	else
		pr("   status\n");
}

static
repo_list(stat, cn, natp)
	struct	stats *stat;
	natid	cn;
	register struct natstr *natp;
{
	struct	sctstr cap;

#ifndef NEWREPORT
	pr(fmt(" %-3d   %-14.14s ", cn, natp->nat_cnam));
#endif /* NEWREPORT */
	if (god) {
#ifdef NEWREPORT
		pr(fmt(" %-3d   %-14.14s ", cn, natp->nat_cnam));
#endif /* NEWREPORT */
		pr(fmt(" %7.2f   %7.2f     %7.2f    %7.2f  %s\n",
		       natp->nat_level[NAT_TLEV],
		       natp->nat_level[NAT_RLEV],
		       natp->nat_level[NAT_ELEV],
		       natp->nat_level[NAT_HLEV],
		       xyas(natp->nat_xcap, natp->nat_ycap, cnum)));
		return;
	}
	switch (natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW|STAT_SANCT)) {
	case STAT_NORM:
	case (STAT_NORM|STAT_SANCT):
#ifdef NEWREPORT
		pr(fmt(" %-3d   %-14.14s ", cn, natp->nat_cnam));
#endif /* NEWREPORT */
		printdiff(stat->tech, natp->nat_level[NAT_TLEV]);
		printdiff(stat->res, natp->nat_level[NAT_RLEV]);
		printdiff(stat->edu, natp->nat_level[NAT_ELEV]);
		getsect(natp->nat_xcap, natp->nat_ycap, &cap);
		if (cap.sct_own != cn ||
		    cap.sct_type != SCT_CAPIT)
			pr("In flux\n");
		else if (natp->nat_money <= 0)
			pr("Broke\n");
		else
			pr("Active\n");
		break;
	case STAT_SANCT:
#ifndef NEWREPORT
		printdiff(stat->tech, natp->nat_level[NAT_TLEV]);
		printdiff(stat->res, natp->nat_level[NAT_RLEV]);
		printdiff(stat->edu, natp->nat_level[NAT_ELEV]);
		pr("Protected\n");
#endif /* NEWREPORT */
		break;
	case STAT_NEW:
#ifndef NEWREPORT
		pr("none        none        none        New\n");
		break;
#endif /* NEWREPORT */
	case 0:
#ifndef NEWREPORT
		pr("none        none        none        Visitor\n");
#endif /* NEWREPORT */
		break;
	case STAT_SANCT|STAT_NORM|STAT_GOD:
	case STAT_NORM|STAT_GOD:
	case STAT_GOD:
#ifndef NEWREPORT
		pr("superior    superior    superior    DEITY\n");
#endif /* NEWREPORT */
		break;
	default:
		pr("????        ????        ????        ????\n");
		break;
	}
}

static
printdiff(ours, theirs)
	float   ours;
	float   theirs;
{
	float   ratio;
	char   *bp;
	float   diff;

	ratio = (ours + 1.0) / (theirs + 1.0);
	diff = ours - theirs;
	if (ratio < 0.10 || diff < -300.0)
		bp = "superior    ";
	else if (ratio < 0.50 || diff < -50.0)
		bp = "advanced    ";
	else if (ratio < 2.0)
		bp = "similar     ";
	else if (ratio < 10.00 || diff < 50)
		bp = "backward    ";
	else
		bp = "primitive   ";
	pr(bp);
}
