#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/prod.c,v 1.12 89/09/10 17:24:57 mr-frog Exp $";
#endif

/*
 * prod.c
 *
 * calculate production levels.
 *
 * David Muir Sharnoff, 1987.
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "nsc.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "tm.h"
#include "item.h"
#include "file.h"

int
prod()
{
	extern	char *argp[];
	extern	double obrate, uwbrate; 
	extern	int etu_per_update;
	struct	natstr *natp;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	struct	pchrstr *pp;
	double  effic;
	double  maxr;		    /* floating version of max */
	double  prodeff;
	double  real;		    /* floating pt version of act */
	double  work;
	int     act;		    /* actual production */
	int     cost;
	int     i;
	int     max;		    /* production w/infinate materials */
	double  maxtake;
	int     nsect;
	int     take;
	int     mtake;
	int     there;
	int     totcomp;	    /* sum of component amounts */
	int     used;		    /* production w/infinite workforce */
	int     wforce;
	int     it;
	u_short	*amount;	    /* amount for component pointer */
	u_char	*comp;		    /* component pointer */
	u_char	*endcomp;
	u_char  vtype;
	char	*resource;
	int     c;
	char    maxc[3][10];
	char    use[3][10];
	int     items[I_MAX+1];
#ifdef BUDGET
	int	civs=0;
	int	uws=0;
#endif /* BDUGET */
#ifdef MERC
	int	bwork;
	int	twork;
	int	type;
	int	eff;
#endif

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
#ifdef MERC
                getvec(VT_ITEM, items, (char *)&sect, EF_SECTOR);

#ifdef BUDGET
                civs = min(999, (int) ((obrate * (double) etu_per_update + 1.0)
                       * (double) items[I_CIVIL]));
                uws = min(999, (int) ((uwbrate * (double) etu_per_update + 1.0)
                       * (double) items[I_UW]));
#else
		civs = items[I_CIVIL];
		uws = items[I_UW];
#endif /* BUDGET */
		wforce = (int)
			((civs * sect.sct_work) / 100.0
			+ uws + items[I_MILIT] * 2 / 5.0);

		work = etu_per_update * wforce / 100.0;
		bwork = work/2;

		type = sect.sct_type;
		eff = sect.sct_effic;
		if(sect.sct_newtype != type) {
			twork = (eff+3)/4;
			if(twork > bwork) {
				twork = bwork;
			}
			work -= twork;
			bwork -= twork;
			eff -= twork*4;
			if(eff <= 0) {
				type = sect.sct_newtype;
				eff = 0;
			}

			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
			work -= twork;
			eff += twork;
		}
		else if(eff < 100) {
			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
			work -= twork;
			eff += twork;
		}

		if(eff < 60 || (type != SCT_ENLIST && eff < 61))
			continue;

		effic = eff/100.0;
		if (effic > 1.0)
			effic = 1.0;

		if (dchr[type].d_prd == 0 && type != SCT_ENLIST)
			continue;
#else
		if (dchr[sect.sct_type].d_prd == 0 &&
			sect.sct_type != SCT_ENLIST)
			continue;	    /* This type of sector
					     * produces nothing
					     * tangible. */
                getvec(VT_ITEM, items, (char *)&sect, EF_SECTOR);
		/*
		 * workforce that will be available (inc
		 * new babies)
		 */
		wforce = (int)
			min(999, (int) ((obrate * (double) etu_per_update+1.0)
						* (double) items[I_CIVIL]))
						* sect.sct_work / 100.0
			+ min(999, (int) ((uwbrate * (double)etu_per_update+1.0)
						* (double) items[I_UW]))
			+ items[I_MILIT] * 2 / 5;
		effic = (sect.sct_effic + (wforce / 100.0)) / 100.0;
		if (effic < 0.60)
			continue;
		if (effic > 1.0)
			effic = 1.0;
#endif
		totcomp = 0;
		pp = &pchr[dchr[type].d_prd];
		vtype = pp->p_type;
		natp = getnatp(sect.sct_own);
		/*
		 * sect effic  (inc improvements)
		 */
		if (type == SCT_ENLIST)
			goto is_enlist;
		if (pp->p_nrndx != 0) {
			totcomp++;
			resource = ((char *) &sect) + pp->p_nrndx;
			effic = (*resource * effic) / 100.0;
			if (pp->p_nrdep > 0) {
				maxtake = (*resource * 100.0) / pp->p_nrdep;
				if (effic > maxtake)
					effic = maxtake;
			}
		}
		/*
		 * production effic.
		 */
		if (pp->p_nlndx >= 0) {
			prodeff = natp->nat_level[pp->p_nlndx] - pp->p_nlmin;
			if (prodeff < 0.0) {
				prodeff = 0.0;
			}
			prodeff = prodeff / (prodeff + pp->p_nllag);
		} else {
			prodeff = 1.0;
		}
		used = 999;
		comp = pp->p_vtype;
		endcomp = pp->p_vtype + pp->p_nv;
		amount = pp->p_vamt;
		while (comp < endcomp) {
			used = min(used,
			    (int)(getvar((int)*comp, (char *)&sect, EF_SECTOR) /
			    	*amount));
			totcomp += *amount;
			++comp;
			++amount;
		}
		if (totcomp == 0)
			continue;
		/*
		 * is production limited by resources or
		 * workforce?
		 */
#ifndef MERC
		work = etu_per_update * wforce / 100.0;
#endif
		max = (int) (work * effic / (double) totcomp) + 0.5;
		act = min(used, max);
		/*
		 * some things are easier to make..  food,
		 * pet, etc.
		 */
		act = (int) (pp->p_effic * 0.01 * act) + 0.5;
		max = (int) (pp->p_effic * 0.01 * max) + 0.5;

		real = act * prodeff;
		maxr = max * prodeff;

		if (vtype != 0) {
			if (real < 0.0)
				real = 0.0;
			if ((there = getvar(
				(int)vtype, (char *)&sect, EF_SECTOR)) >= 999) {
				/*
				 * production backlog
				 */
				there = 999;
			}
			act = min(act, 999 - there);
			max = min(max, 999 - there);
		}
		if (prodeff != 0) {
			take = real / prodeff;
			mtake = maxr / prodeff;
		} else
			mtake = take = 0.0;

		cost = take * pp->p_cost;

		take = take / ((double) pp->p_effic * 0.01);
		mtake = mtake / ((double) pp->p_effic * 0.01);

		comp = pp->p_vtype;
		amount = pp->p_vamt;
		i = 0;
		while (comp < endcomp) {
			it = unitem((int) *comp);
			if (it > 0 && it <= I_MAX && ichr[it].i_name != 0)
				c = ichr[it].i_name[0];
			else
				c = ' ';
			(void) sprintf(use[i], " %3d%c",
				(int) (take * (double) *amount + 0.5), c);

			(void) sprintf(maxc[i], " %3d%c",
				(int) (mtake * (double) *amount + 0.5), c);

			++comp;
			++amount;
			++i;
		}
		while (i < 3) {
			strcpy(use[i], "     ");
			strcpy(maxc[i], "     ");
			++i;
		}


is_enlist:

		if (nsect++ == 0) {
			pr("PRODUCTION SIMULATION\n");
			pr("   sect  des eff wkfc will make- p.e. cost  use1 use2 use3  max1 max2 max3  max\n");
		}
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[type].d_mnem));
		pr(fmt(" %3.0f%%", effic * 100.0));

		pr(fmt(" %4d", wforce));
		if (vtype != 0) {
			pr(fmt(" %4d", (int) (real + 0.5)));
		} else if (type != SCT_ENLIST) {
			switch (pp->p_level) {
			case NAT_TLEV:
			case NAT_RLEV:
				pr(fmt(" %1.2f", real));
				break;
			case NAT_ELEV:
			case NAT_HLEV:
				pr(fmt(" %4.0f", real));
				break;
			default:
				pr(fmt("ERROR"));
				break;
			}
		} else {
#ifdef MERC
			int	maxmil;
			int	enlisted;
			int	civs;

			civs = min(999, (int) ((obrate * (double) etu_per_update + 1.0)
						       * (double) items[I_CIVIL]));
			enlisted = 0;
			maxmil = (civs / 2) - items[I_MILIT];
			if (maxmil > 0) {
				enlisted = (etu_per_update * (10 + items[I_MILIT]) * 0.05);
				if (enlisted > maxmil)
					enlisted = maxmil;
			}
			if (enlisted < 0)
				enlisted = 0;
			pr(fmt(" %4d mil   1.00 $%-5d%3dc",
			       enlisted, enlisted * 3, enlisted));
			pr(fmt("            %3dc           %4d\n",
			       enlisted, maxmil, maxmil));
#else
			/* enlistment center.... */
			int     newc = min(999, (int) ((obrate * (double) etu_per_update + 1.0)
						       * (double) items[I_CIVIL]));
			int     mil = items[I_MILIT];
			int     topmil = (mil + 10) * (1.0 + (double) etu_per_update / 20.0);
			int     topciv = newc / 2;
			int     maxciv = newc / (2.0 + (double) etu_per_update / 10.0) - 10;
			int     maxi = topciv - maxciv;
			int     actual = ((topmil > topciv) ?
					  topciv : topmil) - mil;
			if (actual < 0)
				actual = 0;
			pr(fmt(" %4d mil   1.00 $%-5d%3dc",
			       actual, actual * 3, actual));
			pr(fmt("            %3dc           %4d\n",
			       actual, maxi, maxi));
#endif
			continue;
		}

		pr(fmt(" %-5.5s", pp->p_sname));
		pr(fmt(" %.2f", prodeff));
		pr(fmt(" $%-4d", cost));
		for (i = 0; i < 3; i++) {
			pr(use[i]);
		}
		pr(" ");
		for (i = 0; i < 3; i++) {
			pr(maxc[i]);
		}
		if (vtype != 0 || pp->p_level == NAT_ELEV
		    || pp->p_level == NAT_HLEV)
			pr(fmt(" %4d\n", (int)(max * prodeff + 0.05)));
		else
			pr(fmt(" %1.2f\n", maxr));
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return RET_OK;
}
