/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/

/***********************************************************************

scores.c: Keeping track of scores and management of high-score-list

*****************************************************end of header*****/

#include "scores.h"
#include "bdash.h"
#include "systems.h"

#include <ctype.h>
#include <stdio.h>

#ifdef OS_DOS
#	include <conio.h>
#	define 	CR	'\r'
#	define 	BS	8
#else
#	define 	CR	10
#	define 	BS	127
#endif

#include "graphic.h"
#include "graphic/gr_interface.h"


static unsigned long _score = 0;

struct highscore_entry highscore_table[10] = {
{"",0ul,0u},{"",0ul,0u},{"",0ul,0u},{"",0ul,0u},{"",0ul,0u},
{"",0ul,0u},{"",0ul,0u},{"",0ul,0u},{"",0ul,0u},{"",0ul,0u}};

void display_score(void)
{
	gr_display_score(_score);
}

#define STD_SCORE	5

unsigned long get_score(void)
{
	return _score;
}

void increment_score(int factor)
{
	_score += factor * STD_SCORE;
#ifdef CHEATING_ENABLED
	if(globale_flags.cheating)
		_score = 1;
#endif
	display_score();
}

#ifndef DUMMY_VERSION
static void edit_line(int x, int y, char *line)
{
	char input, buf[2]="X";
	int pos = 0;

	do
	{       write_text(x,y,"_");
		update_graphics();
		input = getch();
		gr_fillbox(x,y,8,8,BLUE);
		if(pos < 19 && isprint(input))
		{	*buf = line[pos++] = input;
			write_text(x,y,buf);
			gr_fillbox(x+=8,y,8,8,BLUE); 
		}
		else if(input == BS && pos > 0) /* Backspace */
		{	pos--;
			gr_fillbox(x-=8,y,8,8,BLUE);
		}
	}while(input != CR);
	line[pos] = '\0';
}

void display_scoretable(void)
{
	int i,j,x = gr_maxx>>1,y,y2,x1,y1,x2;
	char linebuffer[41];

	CLEAR_KEY_BUF

	gr_fillbox(x1=24,y1=(gr_maxy>>1)-80, x2=gr_maxx-48, y2=(gr_maxy>>1)+30,BLUE);
	x2 += 24; y2 += 18; x1-=1;
	gr_line(x1,y1,x2,y1,TEXTCOLOR);
	gr_line(x1,y2,x2,y2,TEXTCOLOR);
	gr_line(x1,y1,x1,y2,TEXTCOLOR);
	gr_line(x2,y1,x2,y2,TEXTCOLOR);
 	gr_line(x1+1,y2+1,x2+1,y2+1,0);
	gr_line(x2+1,y1+1,x2+1,y2+1,0);
	gr_line(x1+2,y2+2,x2+2,y2+2,0);
	gr_line(x2+2,y1+2,x2+2,y2+2,0);

	
	write_text(x-TEXTWIDTH("Hall Of Fame")/2,24,"Hall Of Fame");

	for(y = 64, i = 0; i < 10; y+=8,i++)
	{	sprintf(linebuffer,"%3u:%-20s : %7lu",
			highscore_table[i].level,
			highscore_table[i].name,
			highscore_table[i].score);
		write_text(x-TEXTWIDTH(linebuffer)/2,y,linebuffer);
	}
	for(y = 64, i = 0; i < 10; y+=8, i++)
		if(_score > highscore_table[i].score)
		{       for(y2=136, j=9;j>i;y2-=8,j--)
			{	highscore_table[j] = highscore_table[j-1];
				gr_fillbox(24,y2,gr_maxx-48,8,BLUE);
				sprintf(linebuffer,"%3u:%-20s : %7lu",
					highscore_table[j].level,
					highscore_table[j].name,
					highscore_table[j].score);
					write_text(x-TEXTWIDTH(linebuffer)/2,y2,linebuffer);
		}

			gr_fillbox(24,y,gr_maxx-48,8,BLUE);
			sprintf(linebuffer,"%3u:%-20s : %7lu",
				act_level,
				"",
				_score);
			write_text(x-TEXTWIDTH(linebuffer)/2,y,linebuffer);
			edit_line(55,y,highscore_table[i].name);
			highscore_table[i].score = _score;
			highscore_table[i].level = act_level;
			break;
		}
	update_graphics();
	WAITKEY	
}
#else

static void edit_line(int x, int y, char *line) {}
void display_scoretable(void){}
#endif


