# include "Queue.h"
# include "Queue.r"

/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
*/

static struct Object * Queue_add (void * _self, const void * element, va_list * app) {
	return addLast(_self, element);
}

static struct Object * Queue_take (void * _self) {
	return takeFirst(_self);
}

static const void * initQueue (void)
{
	return ((struct Object *) Queue) -> class ? Queue :
		(Queue = new(ListClass,
			"Queue", List, sizeof(struct Queue),
			add, "add", Queue_add,
			take, "take", Queue_take,
			(void *) 0));
}

static const struct ClassInit _Queue = { { MAGIC }, initQueue };
const void * Queue = & _Queue;
